/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.util;

import com.google.common.base.Stopwatch;
import com.whammich.sstow.ConfigHandler;
import com.whammich.sstow.SoulShardsTOW;
import com.whammich.sstow.api.IEntityHandler;
import com.whammich.sstow.api.SoulShardsAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.monster.ZombieType;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class EntityMapper {
    public static List<String> entityList = new ArrayList<String>();
    public static List<String> specialCases = new ArrayList<String>();
    public static Map<String, Class<? extends EntityLiving>> specialToClass = new HashMap<String, Class<? extends EntityLiving>>();

    public static void mapEntities() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (Map.Entry entry : EntityList.field_75626_c.entrySet()) {
            if (entityList.contains(entry.getValue())) {
                SoulShardsTOW.instance.getLogHelper().info("Already mapped, skipping {}", entry.getValue());
                continue;
            }
            if (((String)entry.getValue()).equals("Mob") || ((String)entry.getValue()).equals("Monster") || !EntityLiving.class.isAssignableFrom((Class)entry.getKey())) continue;
            entityList.add((String)entry.getValue());
        }
        EntityMapper.addSpecialCase("Wither Skeleton", EntitySkeleton.class);
        EntityMapper.addSpecialCase("WitherSkeleton", EntitySkeleton.class);
        EntityMapper.addSpecialCase("Stray", EntitySkeleton.class);
        EntityMapper.addSpecialCase("Husk", EntityZombie.class);
        EntityMapper.addSpecialCase("ElderGuardian", EntityGuardian.class);
        ConfigHandler.handleEntityList("Entity List");
        SoulShardsTOW.instance.getLogHelper().info("Finished mapping, found {} entities in {}", entityList.size(), stopwatch.stop());
    }

    public static void initHandlers() {
        SoulShardsAPI.registerEntityHandler(EntityZombie.class, new IEntityHandler(){

            @Override
            @Nullable
            public ActionResult<? extends EntityLiving> handleLiving(World world, String entityName, BlockPos pos) {
                if (entityName.equals("Husk")) {
                    EntityZombie zombie = new EntityZombie(world);
                    zombie.func_189778_a(ZombieType.HUSK);
                    zombie.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)zombie);
                }
                return SoulShardsAPI.DEFAULT_ENTITY_HANDLER.handleLiving(world, entityName, pos);
            }
        });
        SoulShardsAPI.registerEntityHandler(EntityGuardian.class, new IEntityHandler(){

            @Override
            @Nullable
            public ActionResult<? extends EntityLiving> handleLiving(World world, String entityName, BlockPos pos) {
                if (entityName.equals("ElderGuardian")) {
                    EntityGuardian guardian = new EntityGuardian(world);
                    guardian.func_175465_cm();
                    guardian.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)guardian);
                }
                return SoulShardsAPI.DEFAULT_ENTITY_HANDLER.handleLiving(world, entityName, pos);
            }
        });
        SoulShardsAPI.registerEntityHandler(EntitySkeleton.class, new IEntityHandler(){

            @Override
            @Nullable
            public ActionResult<? extends EntityLiving> handleLiving(World world, String entityName, BlockPos pos) {
                if (entityName.equals("WitherSkeleton") || entityName.equals("Wither Skeleton")) {
                    EntitySkeleton skeleton = new EntitySkeleton(world);
                    skeleton.func_180482_a(world.func_175649_E(pos), null);
                    skeleton.func_189768_a(SkeletonType.WITHER);
                    skeleton.field_70714_bg.func_75776_a(4, (EntityAIBase)ObfuscationReflectionHelper.getPrivateValue(EntitySkeleton.class, (Object)skeleton, (String[])new String[]{"aiAttackOnCollide", "field_85038_e"}));
                    skeleton.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
                    skeleton.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
                    skeleton.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)skeleton);
                }
                if (entityName.equals("Stray")) {
                    EntitySkeleton skeleton = new EntitySkeleton(world);
                    skeleton.func_189768_a(SkeletonType.STRAY);
                    skeleton.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)skeleton);
                }
                return SoulShardsAPI.DEFAULT_ENTITY_HANDLER.handleLiving(world, entityName, pos);
            }
        });
    }

    public static boolean isEntityValid(String entName) {
        return ConfigHandler.entityList.contains(entName);
    }

    public static void addSpecialCase(String name, Class<? extends EntityLiving> homeClass) {
        specialCases.add(name);
        entityList.add(name);
        specialToClass.put(name, homeClass);
    }

    public static Class<? extends EntityLiving> getLivingClass(String entName) {
        if (specialCases.contains(entName)) {
            return specialToClass.get(entName);
        }
        return (Class)EntityList.field_75625_b.get(entName);
    }
}

