/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.util.helper;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogHelper {
    private final Logger logger;
    private final boolean enabled;

    public LogHelper(Logger logger, boolean enabled) {
        this.logger = logger;
        this.enabled = enabled;
    }

    public LogHelper(Logger logger) {
        this(logger, true);
    }

    public LogHelper(String logger, boolean enabled) {
        this(LogManager.getLogger((String)logger), enabled);
    }

    public LogHelper(String logger) {
        this(logger, true);
    }

    public void info(String info, Object ... format) {
        if (this.enabled) {
            this.logger.info(info, format);
        }
    }

    public void error(String error, Object ... format) {
        if (this.enabled) {
            this.logger.error(error, format);
        }
    }

    public void debug(String debug, Object ... format) {
        if (this.enabled) {
            this.logger.debug(debug, format);
        }
    }

    public void severe(String severe, Object ... format) {
        this.logger.fatal(severe, format);
    }

    public Logger getLogger() {
        return this.logger;
    }
}

