/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.translate;

import com.whammich.sstow.shade.lib.translate.LocalizationHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageLocalization
implements IMessage {
    private int helperId;
    private String key;
    private Object[] format;

    public MessageLocalization() {
    }

    public MessageLocalization(int helperId, String key, Object ... format) {
        this.helperId = helperId;
        this.key = key;
        this.format = format;
    }

    public void fromBytes(ByteBuf buf) {
        this.helperId = buf.readInt();
        this.key = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.format = new String[buf.readInt()];
        for (int i = 0; i < this.format.length; ++i) {
            this.format[i] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.helperId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.key);
        buf.writeInt(this.format.length);
        for (Object object : this.format) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)object.toString());
        }
    }

    public static class Handler
    implements IMessageHandler<MessageLocalization, IMessage> {
        public IMessage onMessage(MessageLocalization message, MessageContext ctx) {
            GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
            LocalizationHelper localizationHelper = LocalizationHelper.localizationHelpers.get(message.helperId);
            chat.func_146242_c(localizationHelper.getDeletionId() + localizationHelper.getKeyId(message.key));
            chat.func_146234_a(localizationHelper.localize(message.key, message.format), localizationHelper.getDeletionId() + localizationHelper.getKeyId(message.key));
            return null;
        }
    }
}

