/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.json.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.whammich.sstow.shade.lib.LendingLibrary;
import com.whammich.sstow.shade.lib.json.JsonHelper;
import com.whammich.sstow.shade.lib.json.serialization.SerializerBase;
import java.lang.reflect.Type;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SerializerItemStack
extends SerializerBase<ItemStack> {
    public static final String NAME = "name";
    public static final String AMOUNT = "amount";
    public static final String META = "meta";
    public static final String NBT = "nbt";
    private final boolean nbt;

    public SerializerItemStack(boolean nbt) {
        this.nbt = nbt;
    }

    public SerializerItemStack() {
        this(true);
    }

    @Override
    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ResourceLocation name = new ResourceLocation(JsonHelper.getString(json, NAME, "minecraft:air"));
        int amount = MathHelper.func_76125_a((int)JsonHelper.getInteger(json, AMOUNT, 1), (int)1, (int)64);
        int meta = JsonHelper.getInteger(json, META, 0);
        NBTTagCompound tagCompound = null;
        try {
            if (this.nbt) {
                String nbtJson = JsonHelper.getString(json, NBT, "");
                if (!nbtJson.startsWith("{")) {
                    nbtJson = "{" + nbtJson;
                }
                if (!nbtJson.endsWith("}")) {
                    nbtJson = nbtJson + "}";
                }
                tagCompound = JsonToNBT.func_180713_a((String)nbtJson);
            }
        }
        catch (NBTException e) {
            LendingLibrary.getLogger().error("Error handling NBT string for {}. Is it formatted correctly?", name);
        }
        ItemStack ret = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(name), amount, meta);
        if (this.nbt && tagCompound != null) {
            ret.func_77982_d(tagCompound);
        }
        return ret;
    }

    @Override
    public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(NAME, src.func_77973_b().getRegistryName().toString());
        jsonObject.addProperty(AMOUNT, (Number)src.field_77994_a);
        jsonObject.addProperty(META, (Number)src.func_77952_i());
        if (this.nbt && src.func_77978_p() != null) {
            jsonObject.addProperty(NBT, src.func_77978_p().toString());
        }
        return jsonObject;
    }

    @Override
    public Class<?> getType() {
        return ItemStack.class;
    }
}

