/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.json.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.whammich.sstow.shade.lib.json.JsonHelper;
import com.whammich.sstow.shade.lib.json.serialization.SerializerBase;
import com.whammich.sstow.shade.lib.util.BlockStack;
import java.lang.reflect.Type;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SerializerBlockStack
extends SerializerBase<BlockStack> {
    public static final String NAME = "name";
    public static final String META = "meta";

    @Override
    public BlockStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ResourceLocation name = new ResourceLocation(JsonHelper.getString(json, NAME, "minecraft:air"));
        int meta = JsonHelper.getInteger(json, META, 0);
        return new BlockStack((Block)ForgeRegistries.BLOCKS.getValue(name), meta);
    }

    @Override
    public JsonElement serialize(BlockStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(NAME, src.getBlock().getRegistryName().toString());
        jsonObject.addProperty(META, (Number)src.getMeta());
        return jsonObject;
    }

    @Override
    public Class<?> getType() {
        return BlockStack.class;
    }
}

