/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.impl;

import com.whammich.sstow.shade.lib.LendingLibrary;
import com.whammich.sstow.shade.lib.annot.Handler;
import com.whammich.sstow.shade.lib.iface.IMeshProvider;
import com.whammich.sstow.shade.lib.iface.IVariantProvider;
import com.whammich.sstow.shade.lib.impl.CommonHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ClientHandler
extends CommonHandler {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        for (ASMDataTable.ASMData data : LendingLibrary.getInstance().getModHandlers()) {
            try {
                Class<?> asmClass = Class.forName(data.getClassName());
                boolean client = asmClass.getAnnotation(Handler.class).client();
                Object handler = asmClass.newInstance();
                if (!client) continue;
                MinecraftForge.EVENT_BUS.register(handler);
            }
            catch (Exception e) {
                LendingLibrary.getLogger().error("Unable to register event handler for class {}", data.getClassName());
            }
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
    }

    @Override
    public void tryHandleBlockModel(Block block, String name) {
        if (block instanceof IVariantProvider) {
            IVariantProvider variantProvider = (IVariantProvider)block;
            for (Pair<Integer, String> variant : variantProvider.getVariants()) {
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)((Integer)variant.getLeft()), (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(LendingLibrary.getMODID(), name), (String)variant.getRight()));
            }
        }
    }

    @Override
    public void tryHandleItemModel(Item item, String name) {
        block4: {
            block3: {
                if (!(item instanceof IMeshProvider)) break block3;
                IMeshProvider meshProvider = (IMeshProvider)item;
                ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshProvider.getMeshDefinition());
                ResourceLocation resourceLocation = meshProvider.getCustomLocation();
                if (resourceLocation == null) {
                    resourceLocation = new ResourceLocation(LendingLibrary.getMODID(), "item/" + name);
                }
                for (String variant : meshProvider.getVariants()) {
                    ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(resourceLocation, variant)});
                }
                break block4;
            }
            if (!(item instanceof IVariantProvider)) break block4;
            IVariantProvider variantProvider = (IVariantProvider)item;
            for (Pair<Integer, String> variant : variantProvider.getVariants()) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)((Integer)variant.getLeft()), (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(LendingLibrary.getMODID(), "item/" + name), (String)variant.getRight()));
            }
        }
    }
}

