/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.compat.tconstruct;

import com.google.common.collect.ImmutableList;
import com.whammich.sstow.util.Utils;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ModifierSoulStealer
extends ModifierTrait {
    public ModifierSoulStealer() {
        super("soulStealer", 7999655, 5, 0);
        this.addAspects(new ModifierAspect[]{ModifierAspect.weaponOnly});
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (wasHit && (double)target.func_110143_aJ() <= 0.01) {
            String entName = EntityList.func_75621_b((Entity)target);
            ItemStack shardStack = Utils.getShardFromInv((EntityPlayer)player, entName);
            ModifierNBT data = new ModifierNBT(TinkerUtil.getModifierTag((ItemStack)tool, (String)this.getModifierIdentifier()));
            if (shardStack != null) {
                Utils.increaseShardKillCount(shardStack, data.level);
            }
        }
    }

    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        String loc = String.format("modifier.%s.extra", this.getModifierIdentifier());
        float amount = new ModifierNBT((NBTTagCompound)modifierTag).level;
        return ImmutableList.of((Object)Util.translateFormatted((String)loc, (Object[])new Object[]{Util.df.format(amount)}));
    }
}

