/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.crate;

import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.lib.material.ColorLookupHandler;
import pl.asie.charset.lib.render.ModelColorizer;
import pl.asie.charset.lib.render.ModelFactory;
import pl.asie.charset.lib.render.SimpleBakedModel;
import pl.asie.charset.lib.render.SpritesheetFactory;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.storage.crate.BlockCrate;
import pl.asie.charset.storage.crate.CrateCacheInfo;
import pl.asie.charset.storage.crate.TileEntityCrate;

public class CrateModel
extends ModelFactory<CrateCacheInfo> {
    public final ModelColorizer<CrateCacheInfo> colorizer = new ModelColorizer<CrateCacheInfo>((ModelFactory)this){

        @Override
        public int colorMultiplier(CrateCacheInfo info, int tintIndex) {
            if (info.plank != null) {
                if (tintIndex == 0) {
                    return ColorLookupHandler.INSTANCE.getColor(info.plank, RenderUtils.AveragingMode.FULL);
                }
                if (tintIndex == 1) {
                    return RenderUtils.multiplyColor(ColorLookupHandler.INSTANCE.getColor(info.plank, RenderUtils.AveragingMode.FULL), 0x989898);
                }
            }
            return -1;
        }
    };
    private static final EnumFacing[][] CONNECTION_DIRS = new EnumFacing[][]{{EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.NORTH}};
    private static final Vector3f[] from = new Vector3f[3];
    private static final Vector3f[] to = new Vector3f[3];
    private static final float zOffset = 0.08f;
    private static TextureAtlasSprite baseSprite;
    private static TextureAtlasSprite crossSprite;
    private static TextureAtlasSprite[] borderSprite;

    public CrateModel() {
        super(BlockCrate.PROPERTY, TextureMap.field_174945_f);
        this.addDefaultBlockTransforms();
    }

    private void set(Vector3f vector3f, EnumFacing.Axis axis, float v) {
        switch (axis) {
            case X: {
                vector3f.set(v, vector3f.y, vector3f.z);
                break;
            }
            case Y: {
                vector3f.set(vector3f.x, v, vector3f.z);
                break;
            }
            case Z: {
                vector3f.set(vector3f.x, vector3f.y, v);
            }
        }
    }

    @Override
    public IBakedModel bake(CrateCacheInfo crate, boolean isItem, BlockRenderLayer layer) {
        SimpleBakedModel model = new SimpleBakedModel((IBakedModel)this);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            EnumFacing[][] CONNECTION_DIRS2 = new EnumFacing[][]{{EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.NORTH}};
            Vector3f fromBase = new Vector3f((ReadableVector3f)from[2]);
            Vector3f toBase = new Vector3f((ReadableVector3f)to[2]);
            Vector3f fromCross = new Vector3f((ReadableVector3f)from[1]);
            Vector3f toCross = new Vector3f((ReadableVector3f)to[1]);
            int bsPos = 0;
            for (int i = 0; i < 4; ++i) {
                EnumFacing.AxisDirection axisDir;
                EnumFacing dir = CONNECTION_DIRS2[facing.ordinal()][i];
                if (!crate.isConnected(dir)) {
                    bsPos |= 1 << 3 - i;
                    continue;
                }
                EnumFacing.Axis diffAxis = null;
                for (EnumFacing.Axis axis : EnumFacing.Axis.values()) {
                    if (axis == dir.func_176740_k() || axis == facing.func_176740_k()) continue;
                    diffAxis = axis;
                }
                int corner1 = 0;
                if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                    corner1 |= 1 << 2 - facing.func_176740_k().ordinal();
                }
                if (dir.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                    corner1 |= 1 << 2 - dir.func_176740_k().ordinal();
                }
                int corner2 = corner1 | 1 << 2 - diffAxis.ordinal();
                if (!crate.isCorner(corner1) || crate.isCorner(corner2)) {
                    // empty if block
                }
                if ((axisDir = dir.func_176743_c()) == EnumFacing.AxisDirection.POSITIVE) {
                    this.set(toBase, dir.func_176740_k(), 16.0f);
                    this.set(toCross, dir.func_176740_k(), 16.0f);
                    continue;
                }
                this.set(fromBase, dir.func_176740_k(), 0.0f);
                this.set(fromCross, dir.func_176740_k(), 0.0f);
            }
            model.addQuad(null, RenderUtils.bakeFace(fromBase, toBase, facing, baseSprite, 0));
            model.addQuad(null, RenderUtils.bakeFace(fromCross, toCross, facing, crossSprite, 1));
            if (bsPos == 0 || crate.isConnected(facing)) continue;
            model.addQuad(facing, RenderUtils.bakeFace(from[0], to[0], facing, borderSprite[bsPos], 1));
            Vector3f fromIB = new Vector3f((ReadableVector3f)from[0]);
            Vector3f toIB = new Vector3f((ReadableVector3f)to[0]);
            float v = 15.08f;
            switch (facing.func_176740_k()) {
                case X: {
                    fromIB.translate(v, 0.0f, 0.0f);
                    toIB.translate(-v, 0.0f, 0.0f);
                    bsPos = bsPos & 0xC | (bsPos & 2) >> 1 | (bsPos & 1) << 1;
                    break;
                }
                case Y: {
                    fromIB.translate(0.0f, v, 0.0f);
                    toIB.translate(0.0f, -v, 0.0f);
                    bsPos = bsPos & 3 | (bsPos & 8) >> 1 | (bsPos & 4) << 1;
                    break;
                }
                case Z: {
                    fromIB.translate(0.0f, 0.0f, v);
                    toIB.translate(0.0f, 0.0f, -v);
                    bsPos = bsPos & 0xC | (bsPos & 2) >> 1 | (bsPos & 1) << 1;
                }
            }
            model.addQuad(null, RenderUtils.bakeFace(fromIB, toIB, facing.func_176734_d(), borderSprite[bsPos], 1));
        }
        for (int z = 0; z < 2; ++z) {
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 2; ++x) {
                    if (!crate.isCorner(x, y, z)) continue;
                    Vector3f fFrom = new Vector3f(x == 1 ? 15.08f : 0.0f, y == 1 ? 15.08f : 0.0f, z == 1 ? 15.08f : 0.0f);
                    Vector3f fTo = new Vector3f((ReadableVector3f)fFrom).translate(0.92f, 0.92f, 0.92f);
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        model.addQuad(null, RenderUtils.bakeFace(fFrom, fTo, facing, borderSprite[15], 1));
                    }
                }
            }
        }
        return model;
    }

    @Override
    public CrateCacheInfo fromItemStack(ItemStack stack) {
        TileEntityCrate crate = new TileEntityCrate();
        crate.loadFromStack(stack);
        return crate.getCacheInfo();
    }

    public static void onTextureLoad(TextureMap map) {
        baseSprite = map.func_174942_a(new ResourceLocation("charsetstorage:blocks/crate/base"));
        borderSprite = SpritesheetFactory.register(map, new ResourceLocation("charsetstorage:blocks/crate/border"), 4, 4);
        crossSprite = map.func_174942_a(new ResourceLocation("charsetstorage:blocks/crate/cross"));
    }

    static {
        for (int i = 0; i < 3; ++i) {
            float zi = (float)i * 0.08f;
            if (i > 0) {
                zi += 0.76f;
            }
            CrateModel.from[i] = new Vector3f(zi, zi, zi);
            CrateModel.to[i] = new Vector3f(16.0f - zi, 16.0f - zi, 16.0f - zi);
        }
    }
}

