/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.barrel;

import com.mojang.authlib.GameProfile;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import pl.asie.charset.lib.items.ItemMinecartCharset;
import pl.asie.charset.storage.ModCharsetStorage;
import pl.asie.charset.storage.barrel.BarrelRegistry;
import pl.asie.charset.storage.barrel.EntityMinecartDayBarrel;
import pl.asie.charset.storage.barrel.TileEntityDayBarrel;

public class ItemMinecartDayBarrel
extends ItemMinecartCharset {
    ItemStack creative_cart = null;

    public ItemMinecartDayBarrel() {
        this.func_77655_b("charset.barrelCart");
    }

    @Override
    protected EntityMinecart createCart(GameProfile owner, ItemStack cart, World world, double x, double y, double z) {
        EntityMinecartDayBarrel minecart = new EntityMinecartDayBarrel(world, x + 0.5, y + 0.5, z + 0.5);
        minecart.initFromStack(cart);
        return minecart;
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean verbose) {
        super.func_77624_a(is, player, list, verbose);
        ModCharsetStorage.barrelItem.addExtraInformation(is, player, list, verbose);
    }

    public String func_77653_i(ItemStack is) {
        if (is.func_77942_o()) {
            String name = ModCharsetStorage.barrelItem.func_77653_i(is);
            return I18n.func_74837_a((String)"item.charset.barrelCart.known.name", (Object[])new Object[]{name});
        }
        return super.func_77653_i(is);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        if (this.creative_cart == null) {
            ItemStack creative = null;
            for (ItemStack barrel : BarrelRegistry.INSTANCE.getBarrels()) {
                TileEntityDayBarrel.Type type = TileEntityDayBarrel.getUpgrade(barrel);
                if (type != TileEntityDayBarrel.Type.CREATIVE) continue;
                creative = barrel;
                break;
            }
            if (creative == null) {
                return;
            }
            this.creative_cart = this.makeBarrel(creative);
        }
        if (this.creative_cart != null) {
            list.add(this.creative_cart);
        }
    }

    public ItemStack makeBarrel(ItemStack barrelItem) {
        ItemStack ret = new ItemStack((Item)this, 1, barrelItem.func_77952_i());
        ret.func_77982_d(barrelItem.func_77978_p().func_74737_b());
        return ret;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        TileEntityDayBarrel barrel = new TileEntityDayBarrel();
        barrel.loadFromStack(stack);
        return barrel.getPickedBlock();
    }
}

