/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.barrel;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.blocks.BlockBase;
import pl.asie.charset.lib.utils.GenericExtendedProperty;
import pl.asie.charset.storage.ModCharsetStorage;
import pl.asie.charset.storage.barrel.BarrelCacheInfo;
import pl.asie.charset.storage.barrel.BarrelRegistry;
import pl.asie.charset.storage.barrel.TileEntityDayBarrel;

public class BlockBarrel
extends BlockBase
implements ITileEntityProvider {
    private static final boolean SHOW_ALL_BARRELS = false;
    public static final IUnlistedProperty<BarrelCacheInfo> BARREL_INFO = new GenericExtendedProperty<BarrelCacheInfo>("info", BarrelCacheInfo.class);
    ArrayList<ItemStack> todaysBarrels = null;

    public BlockBarrel() {
        super(Material.field_151575_d);
        this.func_149647_a(ModCharsetLib.CREATIVE_TAB);
        this.func_149711_c(2.5f);
        this.setHarvestLevel("axe", 0);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c("charset.barrel");
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        TileEntity tile = this.getTileAfterBreak(world, pos);
        if (tile instanceof TileEntityDayBarrel) {
            stacks.add(((TileEntityDayBarrel)tile).getDroppedBlock());
        } else {
            stacks.add(new ItemStack((Item)ModCharsetStorage.barrelItem));
        }
        return stacks;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel && ((TileEntityDayBarrel)tile).type == TileEntityDayBarrel.Type.CREATIVE) {
            return -1.0f;
        }
        return this.field_149782_v;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel) {
            return ((TileEntityDayBarrel)tile).getFlamability();
        }
        return 0;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel && ((TileEntityDayBarrel)tile).canRotate(axis)) {
            ((TileEntityDayBarrel)tile).rotate(axis);
            return true;
        }
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDayBarrel();
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{BARREL_INFO});
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel && !((TileEntityDayBarrel)tile).removedByPlayer(player, willHarvest)) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world == null || world.field_72995_K) {
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel) {
            return ((TileEntityDayBarrel)tile).activate(player, side, hand);
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return false;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer playerIn) {
        if (world == null || world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDayBarrel) {
            ((TileEntityDayBarrel)tile).click(playerIn);
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityDayBarrel barrel = (TileEntityDayBarrel)world.func_175625_s(pos);
        IExtendedBlockState extendedBS = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        if (barrel != null) {
            return extendedBS.withProperty(BARREL_INFO, (Object)BarrelCacheInfo.from(barrel));
        }
        return extendedBS;
    }

    public void func_149666_a(Item me, CreativeTabs tab, List<ItemStack> itemList) {
        if (this.todaysBarrels == null) {
            this.todaysBarrels = new ArrayList();
            ArrayList<ItemStack> weeklyBarrels = new ArrayList<ItemStack>();
            Calendar cal = (Calendar)ModCharsetLib.calendar.get();
            int doy = cal.get(6) - 1;
            for (ItemStack barrel : BarrelRegistry.INSTANCE.getBarrels()) {
                TileEntityDayBarrel.Type type = TileEntityDayBarrel.getUpgrade(barrel);
                if (type == TileEntityDayBarrel.Type.NORMAL) {
                    weeklyBarrels.add(barrel);
                    continue;
                }
                if (type != TileEntityDayBarrel.Type.CREATIVE) continue;
                this.todaysBarrels.add(barrel);
            }
            Collections.shuffle(weeklyBarrels, new Random(doy));
            int barrelsToAdd = 1;
            TileEntityDayBarrel rep = new TileEntityDayBarrel();
            for (ItemStack barrel : weeklyBarrels) {
                rep.loadFromStack(barrel);
                for (TileEntityDayBarrel.Type type : TileEntityDayBarrel.Type.values()) {
                    if (type == TileEntityDayBarrel.Type.CREATIVE || type == TileEntityDayBarrel.Type.LARGER) continue;
                    rep.type = type;
                    this.todaysBarrels.add(rep.getPickedBlock());
                }
                if (--barrelsToAdd > 0) continue;
                break;
            }
        }
        itemList.addAll(this.todaysBarrels);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.SOLID;
    }
}

