/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.pipes.pipe;

import io.netty.buffer.ByteBuf;
import mcmultipart.multipart.IMultipart;
import net.minecraft.network.INetHandler;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import pl.asie.charset.lib.network.PacketPart;
import pl.asie.charset.pipes.pipe.PartPipe;
import pl.asie.charset.pipes.pipe.PipeFluidContainer;

public class PacketFluidUpdate
extends PacketPart {
    protected PipeFluidContainer container;
    private boolean ignoreDirty;

    public PacketFluidUpdate() {
    }

    public PacketFluidUpdate(IMultipart part, PipeFluidContainer container, boolean ignoreDirty) {
        super(part);
        this.container = container;
        this.ignoreDirty = ignoreDirty;
    }

    public void readFluidData(ByteBuf buf) {
        if (this.part == null || !(this.part instanceof PartPipe)) {
            return;
        }
        this.container = ((PartPipe)this.part).fluid;
        short sides = buf.readUnsignedByte();
        if ((sides & 0x80) != 0) {
            int fluidID = buf.readInt();
            if (fluidID >= 0) {
                this.container.fluidColor = buf.readInt();
                this.container.fluidStack = new FluidStack(FluidRegistry.getFluid((int)fluidID), 1000);
            } else {
                this.container.fluidColor = 0;
                this.container.fluidStack = null;
            }
        }
        for (int i = 0; i <= 6; ++i) {
            if ((sides & 1 << i) == 0) continue;
            PipeFluidContainer.Tank tank = this.container.tanks[i];
            tank.amount = buf.readUnsignedShort();
        }
    }

    public void writeFluidData(ByteBuf buf) {
        int i;
        int sides = 0;
        if (this.ignoreDirty) {
            sides = 255;
        } else {
            for (i = 0; i <= 6; ++i) {
                if (!this.container.tanks[i].removeDirty()) continue;
                sides |= 1 << i;
            }
            if (this.container.fluidDirty) {
                sides |= 0x80;
                this.container.fluidDirty = false;
            }
        }
        buf.writeByte(sides);
        if ((sides & 0x80) != 0) {
            if (this.container.fluidStack == null) {
                buf.writeInt(-1);
            } else {
                buf.writeInt(FluidRegistry.getFluidID((Fluid)this.container.fluidStack.getFluid()));
                buf.writeInt(this.container.fluidStack.getFluid().getColor(this.container.fluidStack));
            }
        }
        for (i = 0; i <= 6; ++i) {
            if ((sides & 1 << i) == 0) continue;
            buf.writeShort(this.container.tanks[i].amount);
        }
    }

    @Override
    public void readData(INetHandler handler, ByteBuf buf) {
        super.readData(handler, buf);
        this.readFluidData(buf);
    }

    @Override
    public void writeData(ByteBuf buf) {
        super.writeData(buf);
        this.writeFluidData(buf);
    }
}

