/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.carts;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.charset.carts.EntityMinecartImproved;
import pl.asie.charset.carts.ProxyCommon;
import pl.asie.charset.lib.ModCharsetLib;

@Mod(modid="CharsetCarts", name="U", version="0.3.0-pre15", dependencies="required-after:Forge@[11.15.0.1715,);required-after:CharsetLib@0.3.0-pre15;after:mcmultipart", updateJSON="http://charset.asie.pl/update.json", acceptedMinecraftVersions="[1.10]")
public class ModCharsetCarts {
    public static final Map<Class<? extends Entity>, Class<? extends EntityMinecart>> REPLACEMENT_MAP = new HashMap<Class<? extends Entity>, Class<? extends EntityMinecart>>();
    public static final String MODID = "CharsetCarts";
    public static final String NAME = "U";
    public static final String VERSION = "0.3.0-pre15";
    @SidedProxy(clientSide="pl.asie.charset.carts.ProxyClient", serverSide="pl.asie.charset.carts.ProxyCommon")
    public static ProxyCommon proxy;
    @Mod.Instance(value="CharsetCarts")
    public static ModCharsetCarts instance;
    public static Logger logger;
    private Configuration config;

    private void register(Class<? extends EntityMinecart> minecart, String name) {
        EntityRegistry.registerModEntity(minecart, (String)("charsetcarts:" + name), (int)2, (Object)this, (int)64, (int)1, (boolean)true);
    }

    private void register(Class<? extends EntityMinecart> minecart, String name, Class<? extends Entity> from) {
        this.register(minecart, name);
        REPLACEMENT_MAP.put(from, minecart);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = LogManager.getLogger((String)MODID);
        this.config = new Configuration(ModCharsetLib.instance.getConfigFile("carts.cfg"));
        MinecraftForge.EVENT_BUS.register((Object)proxy);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.register(EntityMinecartImproved.class, "rminecart", EntityMinecart.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        Class<?> classy = event.getEntity().getClass();
        if (REPLACEMENT_MAP.containsKey(classy)) {
            try {
                event.setCanceled(true);
                EntityMinecart minecart = REPLACEMENT_MAP.get(classy).getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(event.getWorld(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v);
                event.getWorld().func_72838_d((Entity)minecart);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

