/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.audio.storage;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.codec.binary.Hex;
import pl.asie.charset.audio.ModCharsetAudio;
import pl.asie.charset.audio.storage.DataStorageImpl;

public class DataStorageManager {
    private static final Random rand = new Random();
    private final Map<String, DataStorageImpl> dirtyMap = new HashMap<String, DataStorageImpl>();
    private long lastSave = 0L;
    private File saveDir;

    public DataStorageManager() {
        File saveDirParent = new File(DimensionManager.getCurrentSaveRootDirectory(), "charset");
        if (saveDirParent.exists() || saveDirParent.mkdir()) {
            this.saveDir = new File(saveDirParent, "tape");
            if (!this.saveDir.exists() && !this.saveDir.mkdir()) {
                ModCharsetAudio.logger.error("Could not create save directory! " + saveDirParent.getAbsolutePath());
            }
        } else {
            ModCharsetAudio.logger.error("Could not create save directory! " + saveDirParent.getAbsolutePath());
        }
        this.lastSave = this.time();
    }

    private long time() {
        return new Date().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            boolean shouldStore;
            Map<String, DataStorageImpl> map = this.dirtyMap;
            synchronized (map) {
                shouldStore = this.dirtyMap.size() > 0;
            }
            if (shouldStore && this.lastSave + 30000L < this.time()) {
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markDirty(DataStorageImpl impl) {
        if (impl.getUniqueId() != null) {
            Map<String, DataStorageImpl> map = this.dirtyMap;
            synchronized (map) {
                this.dirtyMap.put(impl.getUniqueId(), impl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        HashSet<DataStorageImpl> dirtySetClone = new HashSet<DataStorageImpl>();
        Map<String, DataStorageImpl> map = this.dirtyMap;
        synchronized (map) {
            dirtySetClone.addAll(this.dirtyMap.values());
            this.dirtyMap.clear();
        }
        for (DataStorageImpl impl : dirtySetClone) {
            impl.writeFile();
        }
    }

    private String filename(String storageName) {
        return storageName + ".dsk";
    }

    public String generateUID() {
        for (int j = 16; j < 32; ++j) {
            int i = 1000;
            while (i > 0) {
                byte[] nameHex = new byte[16];
                rand.nextBytes(nameHex);
                String name = Hex.encodeHexString((byte[])nameHex);
                if (this.exists(name)) continue;
                return name;
            }
        }
        return null;
    }

    public boolean exists(String name) {
        return this.get(name).exists();
    }

    public boolean ready() {
        return this.saveDir != null;
    }

    public File get(String name) {
        return new File(this.saveDir, this.filename(name));
    }
}

