/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.xpframe;

import edgarallen.mods.scf.config.Config;
import edgarallen.mods.scf.items.ModItems;
import edgarallen.mods.scf.util.CommonUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityXPFrame
extends TileEntity {
    public ItemStack xpBottle = new ItemStack((Item)ModItems.xpBottleItem, 1);

    public void extractXPAndEjectBottle(EntityPlayer player) {
        if (this.extractXP(player, Config.xpBottleCapacity)) {
            CommonUtils.ejectItem(this.field_145850_b, this.field_174879_c, 1, this.xpBottle.func_77946_l());
        }
    }

    public void extractAllXPAndEjectBottles(EntityPlayer player) {
        while (this.extractXP(player, Config.xpBottleCapacity)) {
            CommonUtils.ejectItem(this.field_145850_b, this.field_174879_c, 1, this.xpBottle.func_77946_l());
        }
    }

    public int getRealPlayerXP(EntityPlayer player) {
        return (int)((float)this.getXpForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    private int xpBarCapForLevel(int level) {
        return level >= 30 ? 112 + (level - 30) * 9 : (level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2);
    }

    private int getXpForLevel(int level) {
        int xp = 0;
        for (int i = 0; i < level; ++i) {
            xp += this.xpBarCapForLevel(i);
        }
        return xp;
    }

    private int getLevelForXp(int exp) {
        int i = 0;
        while (this.getXpForLevel(i) <= exp) {
            ++i;
        }
        return i - 1;
    }

    private boolean extractXP(EntityPlayer player, int amount) {
        int playerXP = this.getRealPlayerXP(player);
        if (playerXP < amount) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.super_xp_frame.error.insufficient_xp", new Object[0]));
            return false;
        }
        if ((playerXP -= amount) <= 0) {
            player.field_71106_cc = 0.0f;
            player.field_71068_ca = 0;
            player.field_71067_cb = 0;
            return true;
        }
        player.field_71067_cb = playerXP;
        player.field_71068_ca = this.getLevelForXp(playerXP);
        int levelXp = this.getXpForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(playerXP - levelXp) / (float)player.func_71050_bK();
        return true;
    }
}

