/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.teleportationframe.items;

import edgarallen.mods.scf.SuperCraftingFrame;
import edgarallen.mods.scf.blocks.teleportationframe.nbt.DestinationMarkerNBTReader;
import edgarallen.mods.scf.blocks.teleportationframe.nbt.DestinationMarkerNBTWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDestinationMarker
extends Item {
    private static final String NAME = "destination_marker";

    public ItemDestinationMarker() {
        this.func_77655_b(NAME);
        this.setRegistryName(NAME);
        this.setNoRepair();
        this.func_77656_e(0);
        this.func_77637_a(SuperCraftingFrame.superCreativeTab);
        this.func_185043_a(new ResourceLocation("set"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return DestinationMarkerNBTReader.hasDestinationSet(stack) ? 1.0f : 0.0f;
            }
        });
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString(), "inventory"));
    }

    public void registerRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this, 1), (Object[])new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), Items.field_151079_bi, Character.valueOf('X'), Items.field_151148_bJ});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this, 1), (Object[])new Object[]{new ItemStack((Item)this, 1)});
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K && playerIn.func_70093_af()) {
            DestinationMarkerNBTWriter.clearNBT(itemStackIn);
            DestinationMarkerNBTWriter.writeNBTToStack(itemStackIn, playerIn.func_174791_d(), playerIn.field_70177_z, playerIn.field_71093_bK);
            playerIn.func_184185_a(SoundEvents.field_187604_bf, 0.1f, 1.0f);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_74838_a((String)"item.destination_marker.tooltip.subheader"));
        if (DestinationMarkerNBTReader.hasDestinationSet(stack)) {
            String languageKey = "item.destination_marker.tooltip.destination.coords";
            boolean showCoords = true;
            if (stack.func_82837_s()) {
                tooltip.add(I18n.func_74837_a((String)"item.super_teleportation_frame.tooltip.destination.name", (Object[])new Object[]{stack.func_82833_r()}));
                languageKey = "item.super_teleportation_frame.tooltip.destination.coords";
                showCoords = GuiScreen.func_146272_n();
            }
            if (showCoords) {
                Vec3d dest = DestinationMarkerNBTReader.getDestinationPosition(stack);
                tooltip.add(I18n.func_74837_a((String)languageKey, (Object[])new Object[]{new BigDecimal(dest.field_72450_a).setScale(4, RoundingMode.HALF_UP).doubleValue(), new BigDecimal(dest.field_72448_b).setScale(4, RoundingMode.HALF_UP).doubleValue(), new BigDecimal(dest.field_72449_c).setScale(4, RoundingMode.HALF_UP).doubleValue()}));
            }
        } else {
            tooltip.add(I18n.func_74838_a((String)"item.destination_marker.tooltip.destination.none"));
        }
    }
}

