/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.craftingframe.nbt;

import edgarallen.mods.scf.blocks.craftingframe.core.SubFrame;
import edgarallen.mods.scf.util.EnumType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CraftingFrameNBTWriter {
    public static void writeToNBT(EnumType type, SubFrame[] subFrames, NBTTagCompound compound) {
        NBTTagList craftingFrameTagList = new NBTTagList();
        NBTTagCompound rootCompound = new NBTTagCompound();
        CraftingFrameNBTWriter.writeVersionToNBT(rootCompound);
        CraftingFrameNBTWriter.writeTypeToNBT(type, rootCompound);
        CraftingFrameNBTWriter.writeSubFramesToNBT(subFrames, rootCompound);
        craftingFrameTagList.func_74742_a((NBTBase)rootCompound);
        compound.func_74782_a("craftingFrame", (NBTBase)craftingFrameTagList);
    }

    private static void writeVersionToNBT(NBTTagCompound compound) {
        compound.func_74774_a("version", (byte)1);
    }

    private static void writeTypeToNBT(EnumType type, NBTTagCompound compound) {
        compound.func_74774_a("type", (byte)type.ordinal());
    }

    private static void writeSubFramesToNBT(SubFrame[] subFrames, NBTTagCompound rootCompound) {
        NBTTagList subFramesTagList = new NBTTagList();
        for (int i = 0; i < subFrames.length; ++i) {
            SubFrame subFrame = subFrames[i];
            if (subFrame == null || subFrame.isSubFrameDefault()) continue;
            NBTTagCompound compound = new NBTTagCompound();
            CraftingFrameNBTWriter.writeSubFrameIndexToNBT(i, compound);
            CraftingFrameNBTWriter.writeSubFrameModeToNBT(subFrame, compound);
            CraftingFrameNBTWriter.writeSubFrameRecipeToNBT(subFrame, compound);
            CraftingFrameNBTWriter.writeSubFrameRecipeOutputToNBT(subFrame, compound);
            subFramesTagList.func_74742_a((NBTBase)compound);
        }
        rootCompound.func_74782_a("subFrames", (NBTBase)subFramesTagList);
    }

    private static void writeSubFrameIndexToNBT(int subFrameIndex, NBTTagCompound compound) {
        compound.func_74774_a("index", (byte)subFrameIndex);
    }

    private static void writeSubFrameModeToNBT(SubFrame subFrame, NBTTagCompound compound) {
        compound.func_74774_a("mode", (byte)subFrame.getInventoryModeOrdinal());
    }

    private static void writeSubFrameRecipeToNBT(SubFrame subFrame, NBTTagCompound compound) {
        NBTTagList recipeItemsList = new NBTTagList();
        ItemStack[] recipeItems = subFrame.getRecipeItems();
        for (byte slot = 0; slot < recipeItems.length; slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = recipeItems[slot];
            if (stack == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound.func_74774_a("slot", slot);
            CraftingFrameNBTWriter.writeItemStackToNBT(stack, itemCompound);
            recipeItemsList.func_74742_a((NBTBase)itemCompound);
        }
        compound.func_74782_a("recipeItems", (NBTBase)recipeItemsList);
    }

    private static void writeSubFrameRecipeOutputToNBT(SubFrame subFrame, NBTTagCompound compound) {
        ItemStack stack = subFrame.getRecipeOutput();
        if (stack != null) {
            NBTTagList itemRoot = new NBTTagList();
            NBTTagCompound itemCompound = new NBTTagCompound();
            stack.func_77955_b(itemCompound);
            itemRoot.func_74742_a((NBTBase)itemCompound);
            compound.func_74782_a("recipeOutput", (NBTBase)itemRoot);
        }
    }

    private static void writeItemStackToNBT(ItemStack stack, NBTTagCompound compound) {
        NBTTagList itemRoot = new NBTTagList();
        NBTTagCompound itemCompound = new NBTTagCompound();
        stack.func_77955_b(itemCompound);
        itemRoot.func_74742_a((NBTBase)itemCompound);
        compound.func_74782_a("item", (NBTBase)itemRoot);
    }
}

