/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.tileentity;

import com.minemaarten.signals.capabilities.CapabilityDestinationProvider;
import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.network.GuiSynced;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.PacketSpawnParticle;
import com.minemaarten.signals.rail.RailCacheManager;
import com.minemaarten.signals.rail.RailWrapper;
import com.minemaarten.signals.tileentity.IGUITextFieldSensitive;
import com.minemaarten.signals.tileentity.TileEntityBase;
import com.minemaarten.signals.tileentity.TileEntitySignalBase;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;

public class TileEntityStationMarker
extends TileEntityBase
implements ITickable,
IGUITextFieldSensitive {
    private static int nextId;
    @GuiSynced
    private String stationName = "Station" + nextId++;
    private boolean firstTick = true;

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("stationName", this.stationName);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.stationName = compound.func_74779_i("stationName");
    }

    public String getStationName() {
        return this.stationName;
    }

    private void updateNeighborRailCache() {
        for (RailWrapper rail : this.getNeighborRails()) {
            rail.updateStationCache();
        }
    }

    public List<RailWrapper> getNeighborRails() {
        ArrayList<RailWrapper> neighbors = new ArrayList<RailWrapper>(1);
        for (EnumFacing d : EnumFacing.values()) {
            RailWrapper rail = RailCacheManager.getInstance(this.func_145831_w()).getRail(this.func_145831_w(), this.func_174877_v().func_177972_a(d));
            if (rail == null) continue;
            neighbors.add(rail);
        }
        return neighbors;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.updateNeighborRailCache();
            RailCacheManager.getInstance(this.func_145831_w()).removeStationMarker(this);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.firstTick) {
                this.firstTick = false;
                this.updateNeighborRailCache();
                if (!this.field_145850_b.field_72995_K) {
                    RailCacheManager.getInstance(this.func_145831_w()).addStationMarker(this);
                }
            }
            this.updateNeighborMinecarts();
        }
    }

    public void updateNeighborMinecarts() {
        for (EntityMinecart cart : TileEntitySignalBase.getMinecarts(this.field_145850_b, this.getNeighborRails())) {
            CapabilityMinecartDestination cap = (CapabilityMinecartDestination)cart.getCapability(CapabilityMinecartDestination.INSTANCE, null);
            if (!cap.getCurrentDestinationRegex().matcher(this.getStationName()).matches()) continue;
            cap.nextDestination();
        }
    }

    @Override
    public void setText(int textFieldID, String text) {
        this.stationName = text;
        this.func_70296_d();
        this.sendUpdatePacket();
    }

    @Override
    public String getText(int textFieldID) {
        return this.getStationName();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74778_a("stationName", this.stationName);
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.stationName = pkt.func_148857_g().func_74779_i("stationName");
    }

    public boolean isCartApplicable(EntityMinecart cart, Pattern destinationRegex) {
        if (destinationRegex.matcher(this.getStationName()).matches()) {
            return true;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            CapabilityDestinationProvider cap;
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir));
            if (te == null || (cap = (CapabilityDestinationProvider)te.getCapability(CapabilityDestinationProvider.INSTANCE, null)) == null || !cap.isCartApplicable(te, cart, destinationRegex)) continue;
            for (int i = 0; i < 10; ++i) {
                double x = (double)this.func_174877_v().func_177958_n() + this.func_145831_w().field_73012_v.nextDouble();
                double z = (double)this.func_174877_v().func_177952_p() + this.func_145831_w().field_73012_v.nextDouble();
                NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.ENCHANTMENT_TABLE, x, this.func_174877_v().func_177956_o() + 1, z, dir.func_82601_c(), dir.func_96559_d(), dir.func_82599_e()), this.func_145831_w());
            }
            return true;
        }
        return false;
    }
}

