/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.gui.IBeefGuiControl;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;

public abstract class BeefGuiControlBase
implements IBeefGuiControl {
    protected BeefGuiBase guiContainer;
    protected int absoluteX;
    protected int absoluteY;
    protected int relativeX;
    protected int relativeY;
    protected int width;
    protected int height;
    public boolean visible;

    protected BeefGuiControlBase(BeefGuiBase container, int absoluteX, int absoluteY, int width, int height) {
        this.guiContainer = container;
        this.absoluteX = absoluteX;
        this.absoluteY = absoluteY;
        this.relativeX = absoluteX - container.getGuiLeft();
        this.relativeY = absoluteY - container.getGuiTop();
        this.height = height;
        this.width = width;
        this.visible = true;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.absoluteX && mouseX <= this.absoluteX + this.width && mouseY >= this.absoluteY && mouseY <= this.absoluteY + this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void onMouseClicked(int mouseX, int mouseY, int mouseButton) {
    }

    protected static void drawRect(int xMin, int yMin, int xMax, int yMax, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        BeefGuiControlBase.drawRect(xMin, yMin, xMax, yMax, r, g, b, a);
    }

    protected static void drawRect(int xMin, int yMin, int xMax, int yMax, float r, float g, float b, float a) {
        int temp;
        if (xMax < xMin) {
            temp = xMin;
            xMin = xMax;
            xMax = temp;
        }
        if (yMax < yMin) {
            temp = yMin;
            yMin = yMax;
            yMax = temp;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        vertexBuffer.func_181668_a(7, vertexBuffer.func_178973_g());
        vertexBuffer.func_181662_b((double)xMin, (double)yMax, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)xMax, (double)yMax, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)xMax, (double)yMin, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)xMin, (double)yMin, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public boolean isVisible() {
        return this.visible;
    }
}

