/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures.nbt;

import com.rwtema.extrautils2.compatibility.StackHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class NBTSerializer<T> {
    private HashMap<String, Function<T, NBTBase>> getters;
    private HashMap<String, ToByteFunction<T>> gettersByte;
    private HashMap<String, ToShortFunction<T>> gettersShort;
    private HashMap<String, ToIntFunction<T>> gettersInt;
    private HashMap<String, ToLongFunction<T>> gettersLong;
    private HashMap<String, ToFloatFunction<T>> gettersFloat;
    private HashMap<String, ToDoubleFunction<T>> gettersDouble;
    private HashMap<String, BiConsumer<T, NBTBase>> setters;
    private HashMap<String, ObjByteConsumer<T>> settersByte;
    private HashMap<String, ObjShortConsumer<T>> settersShort;
    private HashMap<String, ObjIntConsumer<T>> settersInt;
    private HashMap<String, ObjLongConsumer<T>> settersLong;
    private HashMap<String, ObjFloatConsumer<T>> settersFloat;
    private HashMap<String, ObjDoubleConsumer<T>> settersDouble;

    public <S extends T> NBTSerializer<S> getSubClassSerializer() {
        NBTSerializer<T> newSerializer = new NBTSerializer<T>();
        if (this.getters != null) {
            newSerializer.getters = new HashMap<String, Function<T, NBTBase>>(this.getters);
        }
        if (this.gettersInt != null) {
            newSerializer.gettersInt = new HashMap<String, ToIntFunction<T>>(this.gettersInt);
        }
        if (this.gettersByte != null) {
            newSerializer.gettersByte = new HashMap<String, ToByteFunction<T>>(this.gettersByte);
        }
        if (this.gettersShort != null) {
            newSerializer.gettersShort = new HashMap<String, ToShortFunction<T>>(this.gettersShort);
        }
        if (this.gettersLong != null) {
            newSerializer.gettersLong = new HashMap<String, ToLongFunction<T>>(this.gettersLong);
        }
        if (this.gettersFloat != null) {
            newSerializer.gettersFloat = new HashMap<String, ToFloatFunction<T>>(this.gettersFloat);
        }
        if (this.gettersDouble != null) {
            newSerializer.gettersDouble = new HashMap<String, ToDoubleFunction<T>>(this.gettersDouble);
        }
        if (this.setters != null) {
            newSerializer.setters = new HashMap<String, BiConsumer<T, NBTBase>>(this.setters);
        }
        if (this.settersInt != null) {
            newSerializer.settersInt = new HashMap<String, ObjIntConsumer<T>>(this.settersInt);
        }
        if (this.settersByte != null) {
            newSerializer.settersByte = new HashMap<String, ObjByteConsumer<T>>(this.settersByte);
        }
        if (this.settersShort != null) {
            newSerializer.settersShort = new HashMap<String, ObjShortConsumer<T>>(this.settersShort);
        }
        if (this.settersLong != null) {
            newSerializer.settersLong = new HashMap<String, ObjLongConsumer<T>>(this.settersLong);
        }
        if (this.settersFloat != null) {
            newSerializer.settersFloat = new HashMap<String, ObjFloatConsumer<T>>(this.settersFloat);
        }
        if (this.settersDouble != null) {
            newSerializer.settersDouble = new HashMap<String, ObjDoubleConsumer<T>>(this.settersDouble);
        }
        return newSerializer;
    }

    public NBTSerializer<T> registerBlockPos(String key, Function<T, BlockPos> getter, BiConsumer<T, BlockPos> setter) {
        this.registerLong(key, t -> ((BlockPos)getter.apply(t)).func_177986_g(), (t, l) -> setter.accept(t, BlockPos.func_177969_a((long)l)));
        return this;
    }

    public NBTSerializer<T> registerString(String key, Function<T, String> getter, BiConsumer<T, String> setter) {
        this.register(key, t -> new NBTTagString((String)getter.apply(t)), (t, nbtBase) -> setter.accept(t, ((NBTTagString)nbtBase).func_150285_a_()));
        return this;
    }

    public <V extends INBTSerializable<K>, K extends NBTBase> NBTSerializer<T> registerSerializable(String key, Function<T, V> getter) {
        this.register(key, t -> ((INBTSerializable)getter.apply(t)).serializeNBT(), (t, nbtBase) -> ((INBTSerializable)getter.apply(t)).deserializeNBT(nbtBase));
        return this;
    }

    public NBTSerializer<T> registerItemStack(String key, Function<T, ItemStack> getter, BiConsumer<T, ItemStack> setter) {
        return this.registerIntermediate(key, getter, setter, StackHelper::serializeSafe, StackHelper::deserializeSafe);
    }

    public <E, V extends NBTBase> NBTSerializer<T> registerIntermediate(String key, Function<T, E> getter, BiConsumer<T, E> setter, Function<E, V> serializer, Function<V, E> deserializer) {
        this.register(key, t -> {
            Object val = getter.apply(t);
            return (NBTBase)serializer.apply(val);
        }, (t, nbtBase) -> {
            Object e = deserializer.apply(nbtBase);
            setter.accept(t, e);
        });
        return this;
    }

    public <E extends Enum<E>> NBTSerializer<T> registerEnum(String key, Class<E> clazz, Function<T, E> getter, BiConsumer<T, E> setter) {
        this.registerInt(key, t -> ((Enum)getter.apply(t)).ordinal(), (t, ordinal) -> {
            Enum e = ((Enum[])clazz.getEnumConstants())[ordinal];
            setter.accept(t, e);
        });
        return this;
    }

    public NBTSerializer<T> register(String key, Function<T, NBTBase> getter, BiConsumer<T, NBTBase> setter) {
        if (this.getters == null) {
            this.getters = new HashMap();
        }
        if (this.setters == null) {
            this.setters = new HashMap();
        }
        this.getters.put(key, getter);
        this.setters.put(key, setter);
        return this;
    }

    public NBTSerializer<T> registerInt(String key, ToIntFunction<T> getter, ObjIntConsumer<T> setter) {
        if (this.gettersInt == null) {
            this.gettersInt = new HashMap();
        }
        if (this.settersInt == null) {
            this.settersInt = new HashMap();
        }
        this.gettersInt.put(key, getter);
        this.settersInt.put(key, setter);
        return this;
    }

    public NBTSerializer<T> registerByte(String key, ToByteFunction<T> getter, ObjByteConsumer<T> setter) {
        if (this.gettersByte == null) {
            this.gettersByte = new HashMap();
        }
        if (this.settersByte == null) {
            this.settersByte = new HashMap();
        }
        this.gettersByte.put(key, getter);
        this.settersByte.put(key, setter);
        return this;
    }

    public NBTSerializer<T> registerShort(String key, ToShortFunction<T> getter, ObjShortConsumer<T> setter) {
        if (this.gettersShort == null) {
            this.gettersShort = new HashMap();
        }
        if (this.settersShort == null) {
            this.settersShort = new HashMap();
        }
        this.gettersShort.put(key, getter);
        this.settersShort.put(key, setter);
        return this;
    }

    public NBTSerializer<T> registerLong(String key, ToLongFunction<T> getter, ObjLongConsumer<T> setter) {
        if (this.gettersLong == null) {
            this.gettersLong = new HashMap();
        }
        if (this.settersLong == null) {
            this.settersLong = new HashMap();
        }
        this.gettersLong.put(key, getter);
        this.settersLong.put(key, setter);
        return this;
    }

    public NBTSerializer<T> registerFloat(String key, ToFloatFunction<T> getter, ObjFloatConsumer<T> setter) {
        if (this.gettersFloat == null) {
            this.gettersFloat = new HashMap();
        }
        if (this.settersFloat == null) {
            this.settersFloat = new HashMap();
        }
        this.gettersFloat.put(key, getter);
        this.settersFloat.put(key, setter);
        return this;
    }

    public NBTSerializer<T> registerDouble(String key, ToDoubleFunction<T> getter, ObjDoubleConsumer<T> setter) {
        if (this.gettersDouble == null) {
            this.gettersDouble = new HashMap();
        }
        if (this.settersDouble == null) {
            this.settersDouble = new HashMap();
        }
        this.gettersDouble.put(key, getter);
        this.settersDouble.put(key, setter);
        return this;
    }

    public void deserialize(T t, NBTTagCompound tag) {
        if (this.setters != null) {
            for (Map.Entry<String, Object> entry2 : this.setters.entrySet()) {
                if (!tag.func_74764_b(entry2.getKey())) continue;
                ((BiConsumer)entry2.getValue()).accept(t, tag.func_74781_a(entry2.getKey()));
            }
        }
        if (this.settersByte != null) {
            for (Map.Entry<String, Object> entry3 : this.settersByte.entrySet()) {
                if (!tag.func_74764_b(entry3.getKey())) continue;
                ((ObjByteConsumer)entry3.getValue()).accept(t, tag.func_74771_c(entry3.getKey()));
            }
        }
        if (this.settersShort != null) {
            for (Map.Entry<String, Object> entry4 : this.settersShort.entrySet()) {
                if (!tag.func_74764_b(entry4.getKey())) continue;
                ((ObjShortConsumer)entry4.getValue()).accept(t, tag.func_74765_d(entry4.getKey()));
            }
        }
        if (this.settersInt != null) {
            for (Map.Entry<String, Object> entry5 : this.settersInt.entrySet()) {
                if (!tag.func_74764_b(entry5.getKey())) continue;
                ((ObjIntConsumer)entry5.getValue()).accept(t, tag.func_74762_e(entry5.getKey()));
            }
        }
        if (this.settersLong != null) {
            for (Map.Entry<String, Object> entry6 : this.settersLong.entrySet()) {
                if (!tag.func_74764_b(entry6.getKey())) continue;
                ((ObjLongConsumer)entry6.getValue()).accept(t, tag.func_74763_f(entry6.getKey()));
            }
        }
        if (this.settersFloat != null) {
            for (Map.Entry<String, Object> entry7 : this.settersFloat.entrySet()) {
                if (!tag.func_74764_b(entry7.getKey())) continue;
                ((ObjFloatConsumer)entry7.getValue()).accept(t, tag.func_74760_g(entry7.getKey()));
            }
        }
        if (this.settersDouble != null) {
            for (Map.Entry<String, Object> entry8 : this.settersDouble.entrySet()) {
                if (!tag.func_74764_b(entry8.getKey())) continue;
                ((ObjDoubleConsumer)entry8.getValue()).accept(t, tag.func_74769_h(entry8.getKey()));
            }
        }
    }

    public NBTTagCompound serialize(T t) {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.getters != null) {
            for (Map.Entry<String, Object> entry2 : this.getters.entrySet()) {
                tag.func_74782_a(entry2.getKey(), (NBTBase)((Function)entry2.getValue()).apply(t));
            }
        }
        if (this.gettersInt != null) {
            for (Map.Entry<String, Object> entry3 : this.gettersInt.entrySet()) {
                tag.func_74768_a(entry3.getKey(), ((ToIntFunction)entry3.getValue()).applyAsInt(t));
            }
        }
        if (this.gettersLong != null) {
            for (Map.Entry<String, Object> entry4 : this.gettersLong.entrySet()) {
                tag.func_74772_a(entry4.getKey(), ((ToLongFunction)entry4.getValue()).applyAsLong(t));
            }
        }
        if (this.gettersByte != null) {
            for (Map.Entry<String, Object> entry5 : this.gettersByte.entrySet()) {
                tag.func_74774_a(entry5.getKey(), ((ToByteFunction)entry5.getValue()).applyAsByte(t));
            }
        }
        if (this.gettersShort != null) {
            for (Map.Entry<String, Object> entry6 : this.gettersShort.entrySet()) {
                tag.func_74777_a(entry6.getKey(), ((ToShortFunction)entry6.getValue()).applyAsShort(t));
            }
        }
        if (this.gettersFloat != null) {
            for (Map.Entry<String, Object> entry7 : this.gettersFloat.entrySet()) {
                tag.func_74776_a(entry7.getKey(), ((ToFloatFunction)entry7.getValue()).applyAsFloat(t));
            }
        }
        if (this.gettersDouble != null) {
            for (Map.Entry<String, Object> entry8 : this.gettersDouble.entrySet()) {
                tag.func_74780_a(entry8.getKey(), ((ToDoubleFunction)entry8.getValue()).applyAsDouble(t));
            }
        }
        return tag;
    }

    public NBTSerializer<T> registerBoolean(String key, Function<T, Boolean> getter, BiConsumer<T, Boolean> setter) {
        return this.registerByte(key, t -> (byte)((Boolean)getter.apply(t) != false ? 1 : 0), (t, value) -> setter.accept(t, value != 0));
    }

    public static interface ObjFloatConsumer<T> {
        public void accept(T var1, float var2);
    }

    public static interface ObjShortConsumer<T> {
        public void accept(T var1, short var2);
    }

    public static interface ObjByteConsumer<T> {
        public void accept(T var1, byte var2);
    }

    public static interface ToFloatFunction<T> {
        public float applyAsFloat(T var1);
    }

    public static interface ToShortFunction<T> {
        public short applyAsShort(T var1);
    }

    public static interface ToByteFunction<T> {
        public byte applyAsByte(T var1);
    }
}

