/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.render;

import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.textures.ImgurTextureHolder;
import com.rwtema.extrautils2.tile.TileScreen;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;

public class TileScreenRenderer
extends TileEntitySpecialRenderer<TileScreen> {
    public static TileScreenRenderer instance = new TileScreenRenderer();
    static float[][] offsets = new float[][]{null, null, {0.0f, 0.0f, 0.1f}, {0.0f, 0.0f, 0.9f}, {0.1f, 0.0f, 0.0f}, {0.9f, 0.0f, 0.0f}};
    static float[][][] vecs = new float[][][]{(float[][])null, (float[][])null, new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}}, new float[][]{{1.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 1.0f}}};
    EnumFacing[] right = new EnumFacing[]{null, null, EnumFacing.EAST, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.SOUTH};

    public void renderTileEntityAt(@Nonnull TileScreen te, double x, double y, double z, float partialTicks, int destroyStage) {
        int w;
        if (!te.active) {
            return;
        }
        EnumFacing side = (EnumFacing)te.getBlockState().func_177229_b((IProperty)XUBlockStateCreator.ROTATION_HORIZONTAL);
        int s = side.ordinal();
        EnumFacing right = this.right[s];
        if (te.canJoinWith(te.func_174877_v().func_177977_b()) || te.canJoinWith(te.func_174877_v().func_177967_a(right, -1))) {
            return;
        }
        int h = 1;
        for (w = 1; w < 8 && te.canJoinWith(te.func_174877_v().func_177967_a(right, w)) && !te.canJoinWith(te.func_174877_v().func_177967_a(right, w).func_177977_b()); ++w) {
        }
        block1: while (h < 8) {
            for (int i = 0; i < w; ++i) {
                if (!te.canJoinWith(te.func_174877_v().func_177981_b(h).func_177967_a(right, i))) break block1;
            }
            ++h;
        }
        ImgurTextureHolder tex = ImgurTextureHolder.getTex(te.id);
        if (tex.width == 0 || tex.height == 0) {
            return;
        }
        this.func_147499_a(tex.getResourceLocationForBinding());
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldrenderer = tessellator.func_178180_c();
        float[][] uvs = new float[][]{{tex.u0, tex.v1}, {tex.u0, tex.v0}, {tex.u1, tex.v0}, {tex.u1, tex.v1}};
        float[] offset = offsets[s];
        GlStateManager.func_179109_b((float)offset[0], (float)offset[1], (float)offset[2]);
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float scale = Math.min((float)w / (float)tex.width, (float)h / (float)tex.height);
        float dx = (float)tex.width * scale - 0.03125f;
        float dy = (float)tex.height * scale - 0.03125f;
        float x0 = ((float)w - dx) / 2.0f;
        float y0 = ((float)h - dy) / 2.0f;
        for (int i = 3; i >= 0; --i) {
            float[] vec = vecs[s][i];
            float[] uv = uvs[i];
            worldrenderer.func_181662_b(s >= 4 ? 0.0 : (double)(x0 + vec[0] * dx), (double)(y0 + vec[1] * dy), s < 4 ? 0.0 : (double)(x0 + vec[2] * dx)).func_187315_a((double)uv[0], (double)uv[1]).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
    }
}

