/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.power.energy;

import cofh.api.energy.IEnergyReceiver;
import com.rwtema.extrautils2.network.SpecialChat;
import com.rwtema.extrautils2.power.IPowerSubType;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.power.energy.EnergyTransfer;
import com.rwtema.extrautils2.power.energy.PublicEnergyWrapper;
import com.rwtema.extrautils2.power.energy.XUEnergyStorage;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.utils.Lang;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;

public class TilePowerBattery
extends TilePower
implements IEnergyReceiver,
IPowerSubType {
    public static final int ENERGY_REQUIREMENT = 4;
    public static final int ENERGY_CAPACITY = 3200;
    public XUEnergyStorage energy = this.registerNBT("energy", new XUEnergyStorage(3200));
    PublicEnergyWrapper.Receive receive = new PublicEnergyWrapper.Receive((IEnergyStorage)this.energy){

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            return TilePowerBattery.this.gridReceivesEnergy(maxReceive, simulate);
        }
    };

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.energy.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.gridReceivesEnergy(maxReceive, simulate);
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyHandler(EnumFacing facing) {
        return super.getEnergyHandler(facing);
    }

    private int gridReceivesEnergy(int maxReceive, boolean simulate) {
        PowerManager.PowerFreq freq;
        Collection batteries;
        int received = this.energy.receiveEnergy(maxReceive, simulate);
        if (received < maxReceive && (batteries = (freq = PowerManager.instance.getPowerFreq(this.frequency)).getSubTypes(EnergyTransfer.ENERGY_SYSTEM_STORAGE_KEY)) != null) {
            for (TilePowerBattery battery : batteries) {
                if (battery == this || !simulate && !battery.isLoaded() || (received += battery.energy.receiveEnergy(maxReceive - received, simulate)) != maxReceive) continue;
                return received;
            }
        }
        return received;
    }

    @Override
    public float getPower() {
        return 4.0f;
    }

    @Override
    public void onPowerChanged() {
    }

    @Override
    public Collection<ResourceLocation> getTypes() {
        return EnergyTransfer.ENERGY_SYSTEM_STORAGE;
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TextComponentTranslation chat = Lang.chat("Stored Energy (Battery): %s / %s RF", this.energy.getEnergyStored(), 3200);
            PowerManager.PowerFreq freq = PowerManager.instance.getPowerFreq(this.frequency);
            Collection batteries = freq.getSubTypes(EnergyTransfer.ENERGY_SYSTEM_STORAGE_KEY);
            if (batteries != null) {
                int t = 0;
                for (TilePowerBattery battery : batteries) {
                    t += battery.energy.getEnergyStored();
                }
                chat = chat.func_150258_a("\n").func_150257_a((ITextComponent)Lang.chat("Stored Energy (Total): %s / %s RF", t, batteries.size() * 3200));
            }
            SpecialChat.sendChat(playerIn, (ITextComponent)chat);
        }
        return true;
    }
}

