/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.modcompat.tcon;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.ClientRunnable;
import com.rwtema.extrautils2.backend.entries.VoidEntry;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.modcompat.ModCompatibility;
import com.rwtema.extrautils2.modcompat.tcon.MRISupplier;
import com.rwtema.extrautils2.modcompat.tcon.XUTConTextureBase;
import com.rwtema.extrautils2.modcompat.tcon.XUTinkerMaterial;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.XURandom;
import com.rwtema.extrautils2.utils.datastructures.IntPair;
import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

@ModCompatibility(mod="tconstruct")
public class TConstructIntegration
extends VoidEntry {
    List<XUTinkerMaterial> xuTinkerMaterials = ImmutableList.of((Object)new XUTinkerMaterial("xu_demonic_metal", -12449024, "DemonicMetal", null, true){

        @Override
        public void addStats(List<IMaterialStats> stats) {
            stats.add((IMaterialStats)new HeadMaterialStats(80, 0.5f, 8.25f, 1));
            stats.add((IMaterialStats)new HandleMaterialStats(0.25f, 100));
            stats.add((IMaterialStats)new ExtraMaterialStats(20));
            stats.add((IMaterialStats)new BowMaterialStats(0.7f, 1.1f, 4.0f));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public MaterialRenderInfo createRenderInfo() {
            return new MRISupplier("xu_demonic", this);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public TextureAtlasSprite createTexture(TextureAtlasSprite baseTexture, String location) {
            return new XUTConTextureBase(baseTexture, location){

                @Override
                protected void preProcess(int[] datum, Map<IntPair, Integer> valueOverride, Map<IntPair, Integer> colorOverride) {
                    int[] edgeDist = this.getEdgeDist(datum);
                    boolean[] edges = 1.filter(edgeDist, 1);
                    this.addOverrides(colorOverride, edges, 0x550B00);
                    this.addColorPalette(-22016, -7142400, -4061440, -2619648, -1045760);
                }
            };
        }

        @Override
        public void addTraits() {
            this.addTrait((ITrait)new TraitChatty(), "head");
        }

        @Override
        protected int[] createPalette() {
            return new int[]{-12449024, -7142400, -4061440, -34304, -2619648, -1045760, -62720};
        }
    });

    public TConstructIntegration() {
        super("tinkers_construct_integration");
    }

    @Override
    public void init() {
        boolean useFluids = TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery");
        for (final XUTinkerMaterial mat : this.xuTinkerMaterials) {
            ItemStack stack;
            if (useFluids && mat.fluid != null) {
                FluidRegistry.registerFluid((Fluid)mat.fluid);
                if (!FluidRegistry.getBucketFluids().contains(mat.fluid)) {
                    FluidRegistry.addBucketForFluid((Fluid)mat.fluid);
                }
            }
            if (mat.representativeStack != null && StackHelper.isNonNull(stack = mat.representativeStack.get())) {
                mat.material.setRepresentativeItem(stack);
            }
            TinkerRegistry.addMaterial((Material)mat.material);
            if (useFluids && mat.fluid != null) {
                mat.material.setFluid(mat.fluid);
                mat.material.setCastable(true);
            } else {
                mat.material.setCraftable(true);
            }
            mat.addTraits();
            List<IMaterialStats> stats = mat.stats;
            mat.addStats(stats);
            for (IMaterialStats stat : stats) {
                TinkerRegistry.addMaterialStats((Material)mat.material, (IMaterialStats)stat);
            }
            ExtraUtils2.proxy.run(new ClientRunnable(){

                @Override
                @SideOnly(value=Side.CLIENT)
                public void run() {
                    mat.material.setRenderInfo(mat.createRenderInfo());
                }
            });
            if (mat.fluid != null && mat.oreDicSuffix != null) {
                TinkerSmeltery.registerOredictMeltingCasting((Fluid)mat.fluid, (String)mat.oreDicSuffix);
            }
            TinkerSmeltery.registerToolpartMeltingCasting((Material)mat.material);
        }
    }

    private static class TraitChatty
    extends AbstractTrait {
        private final int TIME_BETWEEN_MESSAGES = 2400;
        int timeSinceLastMessage = XURandom.rand.nextInt(2400);

        public TraitChatty() {
            super("xu_whispering", TextFormatting.DARK_RED);
        }

        @SideOnly(value=Side.CLIENT)
        public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
            if (!isSelected || !world.field_72995_K) {
                return;
            }
            if (entity instanceof EntityPlayer) {
                if (Minecraft.func_71410_x().field_71439_g != entity) {
                    return;
                }
                EntityPlayer player = (EntityPlayer)entity;
                --this.timeSinceLastMessage;
                if (this.timeSinceLastMessage < 0) {
                    RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
                    if (objectMouseOver != null && objectMouseOver.field_72313_a == RayTraceResult.Type.ENTITY && objectMouseOver.field_72308_g instanceof EntityPlayer) {
                        this.sendMessage(tool, player, (ITextComponent)Lang.chat("Kill!", new Object[0]));
                    } else {
                        this.sendMessage(tool, player, (ITextComponent)CollectionHelper.getRandomElementMulti(Lang.chat("Time for death and destruction?", new Object[0]), Lang.chat("I'm hungry, feed me.", new Object[0]), Lang.chat("Hey you, let's go kill everything!", new Object[0]), Lang.chat("Murder! Death! Kill!", new Object[0]), Lang.chat("Hack n' slash! Hack n' slash! Hack n' slash! Hack n' slash! Hack n' slash!", new Object[0]), Lang.chat("Feast on their blood.", new Object[0]), Lang.chat("I feel... sharp.", new Object[0]), Lang.chat("I'm ready and willing.", new Object[0]), Lang.chat("Stabby stabby stab!.", new Object[0]), Lang.chat("Let the essence of life and death flow freely.", new Object[0]), Lang.chat("This world is filled with such life and beauty. Let's go destroy it all.", new Object[0])));
                    }
                }
            }
        }

        private void sendMessage(ItemStack tool, EntityPlayer player, ITextComponent message) {
            TextComponentTranslation textcomponenttranslation = new TextComponentTranslation("commands.message.display.incoming", new Object[]{tool.func_82833_r(), message});
            textcomponenttranslation.func_150256_b().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.TRUE);
            player.func_145747_a((ITextComponent)textcomponenttranslation);
            this.timeSinceLastMessage = 2400 << 2 + player.field_70170_p.field_73012_v.nextInt(9600);
        }
    }
}

