/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.gui.backend;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IWidgetServerNetwork;
import com.rwtema.extrautils2.gui.backend.WidgetClickMCButtonBase;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.utils.Lang;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WidgetClickMCButtonChoices<T>
extends WidgetClickMCButtonBase
implements IWidgetServerNetwork {
    public final ArrayList<Choice<T>> choices = new ArrayList();
    int selected = 0;
    int networkState = 0;

    public WidgetClickMCButtonChoices(int x, int y) {
        super(x, y, 18, 18);
    }

    public <V extends WidgetClickMCButtonChoices<T>> V addChoice(T marker, ItemStack stack, String tooltip) {
        int ordinal = this.choices.size();
        Choice<T> choice = new Choice<T>(ordinal, marker, stack, tooltip);
        this.choices.add(choice);
        return (V)this;
    }

    public <V extends WidgetClickMCButtonChoices<T>> V addChoice(T marker, String displayText, ItemStack stack, String tooltip) {
        int ordinal = this.choices.size();
        Choice<T> choice = new Choice<T>(ordinal, marker, displayText, stack, tooltip);
        this.choices.add(choice);
        this.w = Math.max(this.w, 26 + ExtraUtils2.proxy.apply(DynamicContainer.STRING_WIDTH_FUNCTION, displayText));
        return (V)this;
    }

    public <V extends WidgetClickMCButtonChoices<T>> V addChoice(T marker, String displayText, String tooltip) {
        int ordinal = this.choices.size();
        Choice<T> choice = new Choice<T>(ordinal, marker, displayText, tooltip);
        this.choices.add(choice);
        this.w = Math.max(this.w, 8 + ExtraUtils2.proxy.apply(DynamicContainer.STRING_WIDTH_FUNCTION, displayText));
        return (V)this;
    }

    @Override
    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        super.renderBackground(manager, gui, guiLeft, guiTop);
        String displayText = this.choices.get((int)this.selected).displayText;
        if (displayText == null) {
            return;
        }
        int x = !StackHelper.isNull(this.choices.get((int)this.selected).stack) ? this.getX() + 18 + (this.getW() - 18 - gui.getFontRenderer().func_78256_a(displayText)) / 2 : this.getX() + (this.getW() - gui.getFontRenderer().func_78256_a(displayText)) / 2;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int col = 0xE0E0E0;
        if (!this.enabled) {
            col = 0xA0A0A0;
        } else if (this.hover) {
            col = 0xFFFFA0;
        }
        gui.getFontRenderer().func_78276_b(displayText, guiLeft + x, guiTop + this.getY() + 4, col);
        manager.func_110577_a(gui.getWidgetTexture());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
        gui.renderStack(this.choices.get((int)this.selected).stack, guiLeft + this.getX() + 1, guiTop + this.getY() + 1, "");
    }

    @Override
    public List<String> getToolTip() {
        String tooltip = this.choices.get((int)this.selected).tooltip;
        return tooltip != null ? ImmutableList.of((Object)Lang.translate(tooltip)) : null;
    }

    @Override
    public XUPacketBuffer getPacketToSend(int mouseButton) {
        if (mouseButton == 1) {
            --this.selected;
            if (this.selected < 0) {
                this.selected = this.choices.size() - 1;
            }
        } else if (mouseButton == 0) {
            ++this.selected;
            if (this.selected >= this.choices.size()) {
                this.selected = 0;
            }
        } else {
            return null;
        }
        ++this.networkState;
        XUPacketBuffer buffer = new XUPacketBuffer();
        buffer.writeVarInt(this.networkState);
        buffer.writeVarInt(this.selected);
        return buffer;
    }

    @Override
    public void receiveClientPacket(XUPacketBuffer buffer) {
        int newState = buffer.readVarInt();
        int selection = buffer.readVarInt();
        if (newState > this.networkState) {
            this.networkState = newState;
            this.selected = selection;
            Choice<T> choice = this.choices.get(selection);
            this.onSelectedServer(choice.marker);
        }
    }

    protected abstract void onSelectedServer(T var1);

    public abstract T getSelectedValue();

    @Override
    public void addToDescription(XUPacketBuffer packet) {
        T value = this.getSelectedValue();
        for (Choice<T> choice : this.choices) {
            if (!choice.marker.equals(value)) continue;
            this.selected = choice.ordinal;
            break;
        }
        packet.writeVarInt(this.networkState);
        packet.writeVarInt(this.selected);
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        int newNetworkState = packet.readVarInt();
        int newSelected = packet.readVarInt();
        if (newNetworkState < this.networkState) {
            return;
        }
        this.networkState = newNetworkState;
        this.selected = newSelected;
        if (this.selected < 0 || this.selected >= this.choices.size()) {
            throw new RuntimeException("Invalid packet " + this.selected);
        }
    }

    static class Choice<T> {
        final int ordinal;
        final T marker;
        final ItemStack stack;
        @Nullable
        final String tooltip;
        final String displayText;

        public Choice(int ordinal, T marker, String displayText, @Nullable String tooltip) {
            this.ordinal = ordinal;
            this.marker = marker;
            this.displayText = displayText;
            this.tooltip = tooltip;
            this.stack = StackHelper.empty();
        }

        public Choice(int ordinal, T marker, ItemStack stack, String tooltip) {
            this(ordinal, marker, null, stack, tooltip);
        }

        public Choice(int ordinal, T marker, String displayText, ItemStack stack, @Nullable String tooltip) {
            this.ordinal = ordinal;
            this.marker = marker;
            this.stack = stack;
            this.tooltip = tooltip;
            this.displayText = displayText;
        }
    }
}

