/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.energy;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class EnergyRFWrapper
implements IEnergyStorage {
    static final EnumFacing[][] iterators = new EnumFacing[6][];
    @Nullable
    final EnumFacing from;

    public EnumFacing[] getSideIterable() {
        if (this.from == null) {
            return EnumFacing.values();
        }
        return iterators[this.from.ordinal()];
    }

    private EnergyRFWrapper(@Nullable EnumFacing from) {
        this.from = from;
    }

    public boolean isOpen() {
        IEnergyHandler handler = this.getHandler();
        if (this.from == null) {
            for (EnumFacing facing : EnumFacing.values()) {
                if (!handler.canConnectEnergy(facing)) continue;
                return true;
            }
            return false;
        }
        return handler.canConnectEnergy(this.from);
    }

    public abstract IEnergyHandler getHandler();

    public int getEnergyStored() {
        return this.getHandler().getEnergyStored(this.from);
    }

    public int getMaxEnergyStored() {
        return this.getHandler().getMaxEnergyStored(this.from);
    }

    static {
        for (EnumFacing facing : EnumFacing.values()) {
            EnergyRFWrapper.iterators[facing.ordinal()] = new EnumFacing[]{facing};
        }
    }

    public static class Receive
    extends EnergyRFWrapper {
        final IEnergyReceiver receiver;

        public Receive(IEnergyReceiver receiver, EnumFacing from) {
            super(from);
            this.receiver = receiver;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.from == null) {
                int received = 0;
                for (EnumFacing facing : this.getSideIterable()) {
                    if (maxReceive - (received += this.receiver.canConnectEnergy(facing) ? this.receiver.receiveEnergy(facing, maxReceive - received, simulate) : 0) <= 0) break;
                }
                return received;
            }
            return this.receiver.canConnectEnergy(this.from) ? this.receiver.receiveEnergy(this.from, maxReceive, simulate) : 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return this.isOpen();
        }

        @Override
        public IEnergyHandler getHandler() {
            return this.receiver;
        }
    }

    public static class Extract
    extends EnergyRFWrapper {
        final IEnergyProvider provider;

        public Extract(IEnergyProvider provider, EnumFacing from) {
            super(from);
            this.provider = provider;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (this.from == null) {
                int extracted = 0;
                for (EnumFacing facing : this.getSideIterable()) {
                    if (maxExtract - (extracted += this.provider.canConnectEnergy(facing) ? this.provider.extractEnergy(facing, maxExtract - extracted, simulate) : 0) <= 0) break;
                }
                return extracted;
            }
            return this.provider.canConnectEnergy(this.from) ? this.provider.extractEnergy(this.from, maxExtract, simulate) : 0;
        }

        public boolean canExtract() {
            return this.isOpen();
        }

        public boolean canReceive() {
            return false;
        }

        @Override
        public IEnergyHandler getHandler() {
            return this.provider;
        }
    }
}

