/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting;

import com.rwtema.extrautils2.crafting.PlayerSpecificCrafting;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.ItemStackHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class EnchantRecipe
extends PlayerSpecificCrafting {
    private final int enchantLevel;

    public EnchantRecipe(IRecipe recipe, int enchantLevel) {
        super(recipe);
        this.enchantLevel = enchantLevel;
        MinecraftForge.EVENT_BUS.register((Object)new PlayerSpecificCrafting.EventHandler(this));
    }

    @Override
    protected void updatePlayer(EntityPlayerMP foundPlayer) {
        foundPlayer.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(foundPlayer.field_71106_cc, foundPlayer.field_71067_cb, foundPlayer.field_71068_ca));
    }

    @Override
    protected boolean isValidForCrafting(EntityPlayer foundPlayer) {
        return foundPlayer.field_71068_ca >= this.enchantLevel;
    }

    @Override
    public String info() {
        return Lang.translateArgs("%s XP", this.enchantLevel);
    }

    @Override
    protected void finishedCrafting(EntityPlayer player) {
        player.func_71013_b(this.enchantLevel);
    }

    @Override
    protected void addTooltip(ItemTooltipEvent event, ItemStack itemStack) {
        if (this.enchantLevel == 1) {
            ItemStackHelper.addInfoWidth(event.getToolTip(), itemStack, Lang.translate("Requires 1 enchantment level to craft"));
        } else {
            ItemStackHelper.addInfoWidth(event.getToolTip(), itemStack, Lang.translateArgs("Requires %s enchantment levels to craft", this.enchantLevel));
        }
    }
}

