/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.api.machine;

import com.rwtema.extrautils2.api.machine.IMachineRecipe;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineSlot;
import com.rwtema.extrautils2.api.machine.MachineSlotFluid;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public interface RecipeBuilder {
    public static RecipeBuilder newbuilder(Machine machine) {
        Function<Machine, RecipeBuilder> builder = Builder.builder;
        if (builder == null) {
            throw new RuntimeException("ExtraUtils2 not present and available.");
        }
        return builder.apply(machine);
    }

    public RecipeBuilder setEnergy(int var1);

    public RecipeBuilder setProcessingTime(int var1);

    public RecipeBuilder setRFRate(int var1, float var2);

    public RecipeBuilder setItemInput(@Nonnull MachineSlotItem var1, @Nonnull ItemStack var2);

    public RecipeBuilder setItemInput(@Nonnull MachineSlotItem var1, @Nonnull ItemStack var2, int var3);

    public RecipeBuilder setItemInput(@Nonnull MachineSlotItem var1, @Nonnull String var2, int var3);

    public RecipeBuilder setItemInput(@Nonnull MachineSlotItem var1, @Nonnull List<ItemStack> var2, int var3);

    public RecipeBuilder setItemOutput(@Nonnull MachineSlotItem var1, ItemStack var2);

    public RecipeBuilder setItemOutput(MachineSlotItem var1, ItemStack var2, int var3);

    public RecipeBuilder setItemOutput(@Nonnull MachineSlotItem var1, String var2, int var3);

    public RecipeBuilder setItemOutput(@Nonnull MachineSlotItem var1, List<ItemStack> var2, int var3);

    public RecipeBuilder setFluidInputFluidName(@Nonnull MachineSlotFluid var1, @Nonnull String var2, int var3);

    public RecipeBuilder setFluidInputFluidStack(@Nonnull MachineSlotFluid var1, @Nonnull FluidStack var2);

    public RecipeBuilder setFluidInputFluidStack(@Nonnull MachineSlotFluid var1, @Nonnull FluidStack var2, int var3);

    public RecipeBuilder setFluidInputFluidNameList(@Nonnull MachineSlotFluid var1, @Nonnull List<String> var2, int var3);

    public RecipeBuilder setFluidInputFluidStackList(@Nonnull MachineSlotFluid var1, @Nonnull List<FluidStack> var2, int var3);

    public RecipeBuilder setFluidOutput(@Nonnull MachineSlotFluid var1, FluidStack var2);

    public RecipeBuilder setFluidOutput(@Nonnull MachineSlotFluid var1, FluidStack var2, int var3);

    public RecipeBuilder setFluidOutput(@Nonnull MachineSlotFluid var1, String var2, int var3);

    public RecipeBuilder setProbability(@Nonnull MachineSlot var1, float var2);

    public IMachineRecipe build();

    @Nonnull
    public Machine getMachine();

    public static class Builder {
        @Nullable
        public static Function<Machine, RecipeBuilder> builder = null;
    }
}

