/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.client.render;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import shetiphian.core.client.ClientFunction;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.model.CustomModelLoader;
import shetiphian.platforms.client.model.ModelPlatform_Base;
import shetiphian.platforms.client.render.RenderEntityGuiItem;
import shetiphian.platforms.common.entity.EntityGuiItem;

public class RenderRegistry {
    private static RenderRegistry INSTANCE = new RenderRegistry();
    private boolean firstRun = true;

    public static void renderingPreInt() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new CustomModelLoader());
        INSTANCE.registerItemModels();
        INSTANCE.registerEntityRendering();
    }

    public static void renderingInt() {
        INSTANCE.registerColorize();
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        ModelPlatform_Base.rebuildCache();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (this.firstRun) {
            this.firstRun = false;
            ModelPlatform_Base.rebuildCache();
        }
    }

    private ModelResourceLocation resource(String location) {
        return new ModelResourceLocation(location, "inventory");
    }

    private void registerItemModels() {
        Item blockPlatform = Item.func_150898_a((Block)Values.blockPlatform);
        ModelLoader.setCustomModelResourceLocation((Item)blockPlatform, (int)50, (ModelResourceLocation)this.resource("platforms:platformer"));
        ModelResourceLocation platform = this.resource("platforms:builtin/platform");
        for (int meta = 0; meta < 6; ++meta) {
            ModelLoader.setCustomModelResourceLocation((Item)blockPlatform, (int)meta, (ModelResourceLocation)platform);
            ModelLoader.setCustomModelResourceLocation((Item)blockPlatform, (int)(meta + 10), (ModelResourceLocation)platform);
            ModelLoader.setCustomModelResourceLocation((Item)blockPlatform, (int)(meta + 20), (ModelResourceLocation)platform);
        }
        ModelLoader.setCustomModelResourceLocation((Item)Values.itemWrench, (int)0, (ModelResourceLocation)this.resource("platforms:wrench"));
    }

    private void registerColorize() {
        ClientFunction.registerColorize((Block)Values.blockPlatform);
    }

    private void registerEntityRendering() {
        RenderingRegistry.registerEntityRenderingHandler(EntityGuiItem.class, (IRenderFactory)RenderEntityGuiItem.INSTANCE);
    }
}

