/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.nether;

import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.IPlantable;

public class FusewoodTreeGenerator
extends BaseTreeGenerator {
    public final int minTreeHeight;
    public final IBlockState log;
    public final IBlockState leaves;
    public final boolean seekHeight;

    public FusewoodTreeGenerator(int treeHeight, IBlockState log, IBlockState leaves, boolean seekHeight) {
        this.minTreeHeight = treeHeight;
        this.log = log;
        this.leaves = leaves;
        this.seekHeight = seekHeight;
    }

    public FusewoodTreeGenerator(int treeHeight, IBlockState log, IBlockState leaves) {
        this(treeHeight, log, leaves, true);
    }

    BlockPos findGround(World world, BlockPos pos) {
        int returnHeight = 0;
        int y = pos.func_177956_o() - 1;
        do {
            BlockPos position;
            IBlockState state;
            if ((state = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p()))).func_177230_c() != Blocks.field_150424_aL && state.func_177230_c() != Blocks.field_150425_aM && state.func_177230_c() != NaturaNether.netherTaintedSoil && position.func_177956_o() >= 0) continue;
            returnHeight = y + 1;
            break;
        } while (--y > 0);
        return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c() != Blocks.field_150350_a && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) && state.func_177230_c() != Blocks.field_150424_aL && state.func_177230_c() != Blocks.field_150425_aM && state.func_177230_c() != NaturaNether.netherTaintedSoil && !state.func_177230_c().isWood((IBlockAccess)world, pos);
    }

    @Override
    public void generateTree(Random rand, World worldIn, BlockPos position) {
        int height = rand.nextInt(3) + this.minTreeHeight;
        if (height < 4) {
            height = 4;
        }
        if (this.seekHeight && (position = this.findGround(worldIn, position)).func_177956_o() < 0) {
            return;
        }
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            boolean isSoil;
            if (!this.checkClear(worldIn, position, height)) {
                return;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean bl = isSoil = state.func_177230_c() != null && state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)NaturaNether.netherSapling) || state.func_177230_c() == Blocks.field_150424_aL;
            if (isSoil && position.func_177956_o() < 256 - height - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                this.placeCanopy(worldIn, rand, position, height);
                this.placeTrunk(worldIn, position, height);
            }
        }
    }

    boolean checkClear(World worldIn, BlockPos position, int height) {
        boolean flag = true;
        for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
            int range = 1;
            if (j == position.func_177956_o()) {
                range = 0;
            }
            if (j >= position.func_177956_o() + 1 + height - 2) {
                range = 2;
            }
            BlockPos.MutableBlockPos mutableblockpos = new BlockPos.MutableBlockPos();
            for (int l = position.func_177958_n() - range; l <= position.func_177958_n() + range && flag; ++l) {
                for (int i1 = position.func_177952_p() - range; i1 <= position.func_177952_p() + range && flag; ++i1) {
                    if (j >= 0 && j < 256) {
                        if (!this.isReplaceable(worldIn, (BlockPos)mutableblockpos.func_181079_c(l, j, i1))) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        return flag;
    }

    protected void placeCanopy(World worldIn, Random rand, BlockPos position, int height) {
        for (int y = position.func_177956_o() - 3 + height; y <= position.func_177956_o() + height; ++y) {
            int subract = y - (position.func_177956_o() + height);
            int subract2 = 1 - subract / 2;
            for (int x = position.func_177958_n() - subract2; x <= position.func_177958_n() + subract2; ++x) {
                int mathX = x - position.func_177958_n();
                for (int z = position.func_177952_p() - subract2; z <= position.func_177952_p() + subract2; ++z) {
                    BlockPos blockpos;
                    IBlockState state2;
                    int mathZ = z - position.func_177952_p();
                    if (Math.abs(mathX) == subract2 && Math.abs(mathZ) == subract2 && (rand.nextInt(2) == 0 || subract == 0) || !(state2 = worldIn.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos) && !state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos)) continue;
                    worldIn.func_180501_a(blockpos, this.leaves, 2);
                }
            }
        }
    }

    protected void placeTrunk(World worldIn, BlockPos position, int height) {
        for (int localHeight = 0; localHeight < height; ++localHeight) {
            BlockPos upN = position.func_177981_b(localHeight);
            IBlockState state2 = worldIn.func_180495_p(upN);
            if (!state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN)) continue;
            worldIn.func_180501_a(position.func_177981_b(localHeight), this.log, 2);
        }
    }
}

