/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen;

import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.world.worldgen.glowshroom.nether.BlueGlowshroomGenerator;
import com.progwml6.natura.world.worldgen.glowshroom.nether.GreenGlowshroomGenerator;
import com.progwml6.natura.world.worldgen.glowshroom.nether.PurpleGlowshroomGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class GlowshroomGenerator
implements IWorldGenerator {
    public static GlowshroomGenerator INSTANCE = new GlowshroomGenerator();
    GreenGlowshroomGenerator greenGlowshroomGen = new GreenGlowshroomGenerator(NaturaNether.netherLargeGreenGlowshroom.func_176223_P());
    BlueGlowshroomGenerator blueGlowshroomGen = new BlueGlowshroomGenerator(NaturaNether.netherLargeBlueGlowshroom.func_176223_P());
    PurpleGlowshroomGenerator purpleGlowshroomGen = new PurpleGlowshroomGenerator(NaturaNether.netherLargePurpleGlowshroom.func_176223_P());

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateNether(random, chunkX, chunkZ, world);
    }

    public void retroGen(Random random, int chunkX, int chunkZ, World world) {
        this.generateNether(random, chunkX, chunkZ, world);
        world.func_72964_e(chunkX, chunkZ).func_76630_e();
    }

    public void generateNether(Random random, int chunkX, int chunkZ, World world) {
        int xPos = chunkX * 16 + 8;
        int zPos = chunkZ * 16 + 8;
        BlockPos chunkPos = new BlockPos(xPos, 0, zPos);
        Biome biome = world.func_175726_f(chunkPos).func_177411_a(chunkPos, world.func_72959_q());
        if (biome == null) {
            return;
        }
        if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) && Config.generateGlowshroomtree && random.nextInt(35) == 0) {
            for (int iter = 0; iter < 5; ++iter) {
                int xSpawn = xPos + random.nextInt(24) - 4;
                int zSpawn = zPos + random.nextInt(24) - 4;
                int ySpawn = this.findGround(world, xSpawn, random.nextInt(64) + 32, zSpawn);
                BlockPos position = new BlockPos(xSpawn, ySpawn, zSpawn);
                if (random.nextInt(3) == 0) {
                    this.purpleGlowshroomGen.generateShroom(random, world, position);
                    continue;
                }
                if (random.nextInt(2) == 0) {
                    this.greenGlowshroomGen.generateShroom(random, world, position);
                    continue;
                }
                this.blueGlowshroomGen.generateShroom(random, world, position);
            }
        }
    }

    int findGround(World world, int x, int y, int z) {
        boolean foundGround = false;
        int height = y;
        do {
            BlockPos pos;
            Block block;
            if ((block = world.func_180495_p(pos = new BlockPos(x, --height, z)).func_177230_c()) != Blocks.field_150424_aL && block != Blocks.field_150425_aM && block != NaturaNether.netherTaintedSoil && height >= 0) continue;
            foundGround = true;
        } while (!foundGround);
        return height + 1;
    }
}

