/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.util.fluid;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import xreliquary.init.ModFluids;
import xreliquary.init.ModItems;
import xreliquary.util.XpHelper;

public class FluidHandlerHeroMedallion
implements IFluidHandler,
ICapabilityProvider {
    private ItemStack heroMedallion;

    public FluidHandlerHeroMedallion(ItemStack heroMedallion) {
        this.heroMedallion = heroMedallion;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this : null);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(ModFluids.fluidXpJuice, 1000), Integer.MAX_VALUE)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource.getFluid() != ModFluids.fluidXpJuice) {
            return 0;
        }
        if (doFill) {
            ModItems.heroMedallion.setExperience(this.heroMedallion, ModItems.heroMedallion.getExperience(this.heroMedallion) + XpHelper.liquidToExperience(resource.amount));
        }
        return resource.amount;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource.getFluid() != ModFluids.fluidXpJuice) {
            return null;
        }
        int experienceToRemove = Math.min(XpHelper.liquidToExperience(resource.amount), ModItems.heroMedallion.getExperience(this.heroMedallion));
        if (doDrain) {
            ModItems.heroMedallion.setExperience(this.heroMedallion, ModItems.heroMedallion.getExperience(this.heroMedallion) - experienceToRemove);
        }
        return new FluidStack(ModFluids.fluidXpJuice, XpHelper.experienceToLiquid(experienceToRemove));
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.drain(new FluidStack(ModFluids.fluidXpJuice, maxDrain), doDrain);
    }
}

