/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.item;

import codechicken.lib.item.ItemStackRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMultiType
extends Item {
    private HashMap<Integer, String> names = new HashMap();
    private HashMap<Integer, EnumRarity> rarityMap = new HashMap();
    private int nextVariant = 0;
    private boolean hasRegistered = false;
    private boolean registerToStackRegistry = false;

    public ItemMultiType(CreativeTabs tab, String registryName) {
        this.setRegistryName(registryName);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(tab);
        this.setUnlocalizedName(new ResourceLocation(registryName).func_110623_a());
        this.func_77625_d(64);
    }

    public ItemMultiType setUnlocalizedName(String unlocalizedName) {
        super.func_77655_b(unlocalizedName);
        return this;
    }

    public ItemMultiType setUseStackRegistry() {
        this.registerToStackRegistry = true;
        return this;
    }

    public ItemStack registerSubItem(int meta, String name) {
        if (this.names.containsKey(meta)) {
            FMLLog.warning((String)"[ItemMultiType.%s]: Variant %s with meta %s is already registered to %s with meta %s", (Object[])new Object[]{this.getRegistryName(), name, meta, this.names.get(meta), meta});
        }
        this.names.put(meta, name);
        ItemStack stack = new ItemStack((Item)this, 1, meta);
        this.incVariant();
        return stack;
    }

    public ItemStack registerSubItem(int meta, String name, EnumRarity rarity) {
        this.rarityMap.put(meta, rarity);
        return this.registerSubItem(meta, name);
    }

    public ItemStack registerSubItemOreDict(int meta, String name) {
        ItemStack stack = this.registerSubItem(meta, name);
        OreDictionary.registerOre((String)name, (ItemStack)stack);
        if (this.registerToStackRegistry) {
            ItemStackRegistry.registerCustomItemStack(name, stack);
        }
        return stack;
    }

    public ItemStack registerSubItemOreDict(int meta, String name, EnumRarity rarity) {
        this.rarityMap.put(meta, rarity);
        return this.registerSubItemOreDict(meta, name);
    }

    public ItemStack registerSubItem(String name) {
        return this.registerSubItem(this.nextVariant, name);
    }

    public ItemStack registerSubItem(String name, EnumRarity rarity) {
        this.rarityMap.put(this.nextVariant, rarity);
        return this.registerSubItem(name);
    }

    public ItemStack registerSubItemOreDict(String name) {
        ItemStack stack = this.registerSubItem(this.nextVariant, name);
        OreDictionary.registerOre((String)name, (ItemStack)stack);
        if (this.registerToStackRegistry) {
            ItemStackRegistry.registerCustomItemStack(name, stack);
        }
        return stack;
    }

    public ItemStack registerSubItemOreDict(String name, EnumRarity rarity) {
        this.rarityMap.put(this.nextVariant, rarity);
        return this.registerSubItemOreDict(name);
    }

    private void incVariant() {
        if (this.names.containsKey(this.nextVariant)) {
            ++this.nextVariant;
            while (this.names.containsKey(this.nextVariant)) {
                ++this.nextVariant;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModelVariants() {
        if (!this.hasRegistered) {
            for (Map.Entry<Integer, String> entry : this.names.entrySet()) {
                ModelResourceLocation location = new ModelResourceLocation(this.getRegistryName(), "type=" + entry.getValue().toLowerCase());
                ModelLoader.setCustomModelResourceLocation((Item)this, (int)entry.getKey(), (ModelResourceLocation)location);
            }
            this.hasRegistered = true;
        }
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (Map.Entry<Integer, String> entry : this.names.entrySet()) {
            subItems.add(new ItemStack(itemIn, 1, entry.getKey().intValue()));
        }
    }

    public String func_77667_c(ItemStack stack) {
        int meta = stack.func_77952_i();
        return this.func_77658_a() + "." + this.names.get(meta);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (this.rarityMap.containsKey(stack.func_77952_i())) {
            return this.rarityMap.get(stack.func_77952_i());
        }
        return super.func_77613_e(stack);
    }
}

