/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.cc.providers;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Random;
import net.minecraft.tileentity.TileEntity;
import openmods.Log;
import openperipheral.adapter.composed.ComposedMethodsFactory;
import openperipheral.api.peripheral.IBrokenOpenPeripheral;
import openperipheral.interfaces.cc.providers.IPeripheralFactory;
import org.apache.commons.lang3.ArrayUtils;

abstract class SafePeripheralFactory
implements IPeripheralFactory<TileEntity> {
    private static final Random RANDOM = new Random();
    private static final String[] BOGUS_METODS = new String[]{"help", "whats_going_on", "wtf", "lol_nope", "derp", "guru_meditation", "woof", "nothing_to_see_here", "kernel_panic", "hello_segfault", "i_see_dead_bytes", "xyzzy", "abort_retry_fail_continue"};
    private static final IPeripheral PLACEHOLDER = new BrokenPeripheral();
    public static final IPeripheralFactory<TileEntity> BROKEN_FACTORY = new IPeripheralFactory<TileEntity>(){

        @Override
        public IPeripheral getPeripheral(TileEntity obj, int side) {
            return PLACEHOLDER;
        }
    };

    SafePeripheralFactory() {
    }

    @Override
    public IPeripheral getPeripheral(TileEntity tile, int side) {
        if (tile == null) {
            return null;
        }
        try {
            return this.createPeripheral(tile, side);
        }
        catch (ComposedMethodsFactory.InvalidClassException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                Log.severe((Throwable)cause, (String)"Can't create peripheral for TE %s @ (%d,%d,%d) in world %s due to error in class", (Object[])new Object[]{tile.getClass(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile.func_145831_w().field_73011_w.field_76574_g});
            } else {
                Log.severe((String)"Can't create peripheral for TE %s @ (%d,%d,%d) in world %s due to error in class %s", (Object[])new Object[]{tile.getClass(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile.func_145831_w().field_73011_w.field_76574_g, tile.getClass()});
            }
        }
        catch (Throwable t) {
            Log.severe((Throwable)t, (String)"Can't create peripheral for TE %s @ (%d,%d,%d) in world %s", (Object[])new Object[]{tile.getClass(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile.func_145831_w().field_73011_w.field_76574_g});
        }
        return PLACEHOLDER;
    }

    protected abstract IPeripheral createPeripheral(TileEntity var1, int var2) throws Exception;

    private static class BrokenPeripheral
    implements IPeripheral,
    IBrokenOpenPeripheral {
        private BrokenPeripheral() {
        }

        public String getType() {
            return "broken_peripheral";
        }

        public String[] getMethodNames() {
            return (String[])ArrayUtils.toArray((Object[])new String[]{BOGUS_METODS[RANDOM.nextInt(BOGUS_METODS.length)]});
        }

        public void detach(IComputerAccess computer) {
        }

        public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) {
            return ArrayUtils.toArray((Object[])new String[]{"This peripheral is broken. You can show your log in #OpenMods"});
        }

        public void attach(IComputerAccess computer) {
        }

        public boolean equals(IPeripheral other) {
            return other == this;
        }
    }
}

