/*
 * Decompiled with CFR 0.152.
 */
package openperipheral;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import cpw.mods.fml.client.IModGuiFactory;
import cpw.mods.fml.client.config.ConfigGuiType;
import cpw.mods.fml.client.config.DummyConfigElement;
import cpw.mods.fml.client.config.GuiConfig;
import cpw.mods.fml.client.config.GuiConfigEntries;
import cpw.mods.fml.client.config.GuiEditArrayEntries;
import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import openperipheral.ArchitectureChecker;
import openperipheral.OpenPeripheralCore;
import openperipheral.adapter.FeatureGroupManager;

public class ConfigGuiFactory
implements IModGuiFactory {
    private static FeatureGroupManager CONFIG_FEATURE_GROUP_MANAGER;

    public void initialize(Minecraft minecraftInstance) {
        CONFIG_FEATURE_GROUP_MANAGER = FeatureGroupManager.INSTANCE.copy();
    }

    public Class<? extends GuiScreen> mainConfigGuiClass() {
        return ConfigScreen.class;
    }

    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return ImmutableSet.of();
    }

    public IModGuiFactory.RuntimeOptionGuiHandler getHandlerFor(IModGuiFactory.RuntimeOptionCategoryElement element) {
        return null;
    }

    public static class ConfigChangeListener {
        private final Configuration config;

        public ConfigChangeListener(Configuration config) {
            this.config = config;
        }

        @SubscribeEvent
        public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent evt) {
            if ("OpenPeripheralCore".equals(evt.modID)) {
                String[] blacklist = CONFIG_FEATURE_GROUP_MANAGER.saveBlacklist();
                this.config.get("featureGroups", "blacklist", blacklist).set(blacklist);
                this.config.save();
            }
        }
    }

    public static class ConfigScreen
    extends GuiConfig {
        public ConfigScreen(GuiScreen parent) {
            super(parent, ConfigScreen.createConfigElements(), "OpenPeripheralCore", false, true, "Config");
        }

        private static List<IConfigElement> createConfigElements() {
            ArrayList result = Lists.newArrayList();
            result.add(ConfigScreen.createFeatureGroupConfig());
            result.add(ConfigScreen.createModConfig());
            return result;
        }

        private static IConfigElement createModConfig() {
            Configuration config = OpenPeripheralCore.instance.config();
            ArrayList result = Lists.newArrayList();
            for (String categoryName : config.getCategoryNames()) {
                if (categoryName.equalsIgnoreCase("featureGroups")) continue;
                ConfigCategory category = config.getCategory(categoryName);
                result.add(new ConfigElement(category));
            }
            return new DummyConfigElement.DummyCategoryElement("modConfig", "openperipheralcore.config.miscConfig", (List)result);
        }

        private static Collection<String> sorted(Collection<String> c) {
            ArrayList results = Lists.newArrayList(c);
            Collections.sort(results, Ordering.natural().onResultOf((Function)new Function<String, String>(){

                @Nullable
                public String apply(@Nullable String input) {
                    return input != null ? input.toLowerCase() : null;
                }
            }));
            return results;
        }

        private static IConfigElement createFeatureGroupConfig() {
            ArrayList architecturesConfig = Lists.newArrayList();
            for (String architecture : ConfigScreen.sorted(ArchitectureChecker.INSTANCE.knownArchitectures())) {
                architecturesConfig.add(ConfigScreen.createArchitectureConfig(architecture));
            }
            return new DummyConfigElement.DummyCategoryElement("featureGroups", "openperipheralcore.config.featureGroupConfig", (List)architecturesConfig);
        }

        private static IConfigElement createArchitectureConfig(String architecture) {
            ArrayList architectureConfig = Lists.newArrayList();
            for (String feature : ConfigScreen.sorted(FeatureGroupManager.INSTANCE.knownFeatureGroups())) {
                architectureConfig.add(new FeatureConfigElement(architecture, feature));
            }
            return new DummyConfigElement.DummyCategoryElement(architecture, "openperipheralcore.config.architectureConfig", (List)architectureConfig);
        }
    }

    private static class FeatureConfigElement
    implements IConfigElement<Boolean> {
        private final String architecture;
        private final String featureGroup;

        private FeatureConfigElement(String architecture, String feature) {
            this.architecture = architecture;
            this.featureGroup = feature;
        }

        public boolean isProperty() {
            return true;
        }

        public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
            return null;
        }

        public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
            return null;
        }

        public String getName() {
            return this.featureGroup;
        }

        public String getQualifiedName() {
            return this.featureGroup;
        }

        public String getLanguageKey() {
            return this.featureGroup;
        }

        public String getComment() {
            return I18n.func_135052_a((String)"openperipheralcore.config.featureGroupToggle.tooltip", (Object[])new Object[0]);
        }

        public List<IConfigElement> getChildElements() {
            return null;
        }

        public ConfigGuiType getType() {
            return ConfigGuiType.BOOLEAN;
        }

        public boolean isList() {
            return false;
        }

        public boolean isListLengthFixed() {
            return false;
        }

        public int getMaxListLength() {
            return -1;
        }

        public boolean isDefault() {
            return true;
        }

        public Object getDefault() {
            return FeatureGroupManager.INSTANCE.isEnabled(this.featureGroup, this.architecture);
        }

        public Object[] getDefaults() {
            return null;
        }

        public void setToDefault() {
        }

        public boolean requiresWorldRestart() {
            return false;
        }

        public boolean showInGui() {
            return true;
        }

        public boolean requiresMcRestart() {
            return true;
        }

        public Object get() {
            return CONFIG_FEATURE_GROUP_MANAGER.isEnabled(this.featureGroup, this.architecture);
        }

        public Object[] getList() {
            return null;
        }

        public void set(Boolean value) {
            if (value == Boolean.TRUE) {
                CONFIG_FEATURE_GROUP_MANAGER.enable(this.featureGroup, this.architecture);
            } else {
                CONFIG_FEATURE_GROUP_MANAGER.disable(this.featureGroup, this.architecture);
            }
        }

        public void set(Boolean[] aVal) {
        }

        public String[] getValidValues() {
            return null;
        }

        public Boolean getMinValue() {
            return Boolean.FALSE;
        }

        public Boolean getMaxValue() {
            return Boolean.TRUE;
        }

        public Pattern getValidationPattern() {
            return null;
        }
    }
}

