/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.inventory.filters;

import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import net.minecraft.item.ItemStack;

public class CraftingFilter
implements IStackFilter {
    private final ItemStack[] stacks;

    public CraftingFilter(ItemStack ... stacks) {
        this.stacks = stacks;
    }

    @Override
    public boolean matches(ItemStack stack) {
        if (this.stacks.length == 0 || !this.hasFilter()) {
            return true;
        }
        for (ItemStack s : this.stacks) {
            if (!StackHelper.isCraftingEquivalent(s, stack, true)) continue;
            return true;
        }
        return false;
    }

    public ItemStack[] getStacks() {
        return this.stacks;
    }

    public boolean hasFilter() {
        for (ItemStack filter : this.stacks) {
            if (filter == null) continue;
            return true;
        }
        return false;
    }
}

