/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.natura;

import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v3.ICrop;
import com.InfinityRaider.AgriCraft.farming.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirementHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class CropPlantNatura
extends CropPlant {
    private final Item seed;
    private final Item fruit;
    private final Block plant;
    private final int seedMeta;

    public CropPlantNatura(int seedMeta) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        this.seedMeta = seedMeta;
        this.seed = (Item)Item.field_150901_e.func_82594_a("Natura:barley.seed");
        this.fruit = (Item)Item.field_150901_e.func_82594_a("Natura:barleyFood");
        this.plant = ((ItemSeeds)this.seed).getPlant(null, 0, 0, 0);
    }

    @Override
    public int tier() {
        return 2;
    }

    @Override
    public ItemStack getSeed() {
        return new ItemStack(this.seed, 1, this.seedMeta);
    }

    @Override
    public Block getBlock() {
        return this.plant;
    }

    @Override
    public ArrayList<ItemStack> getAllFruits() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(this.fruit, 1, this.seedMeta * 3));
        return list;
    }

    @Override
    public ItemStack getRandomFruit(Random rand) {
        return new ItemStack(this.fruit, 1, this.seedMeta * 3);
    }

    @Override
    public ArrayList<ItemStack> getFruitsOnHarvest(int gain, Random rand) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int amount = (int)Math.ceil(((double)gain + 0.0) / 3.0); amount > 0; --amount) {
            list.add(this.getRandomFruit(rand));
        }
        return list;
    }

    @Override
    public boolean canBonemeal() {
        return true;
    }

    @Override
    protected IGrowthRequirement initGrowthRequirement() {
        return GrowthRequirementHandler.getNewBuilder().build();
    }

    @Override
    public boolean onAllowedGrowthTick(World world, int x, int y, int z, int oldGrowthStage, ICrop crop) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getHeight(int meta) {
        return 0.8125f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getPlantIcon(int growthStage) {
        int meta = 7;
        switch (growthStage) {
            case 0: {
                meta = this.seedMeta * 4;
                break;
            }
            case 1: {
                meta = this.seedMeta * 4;
                break;
            }
            case 2: {
                meta = this.seedMeta * 5;
                break;
            }
            case 3: {
                meta = 1 + this.seedMeta * 4;
                break;
            }
            case 4: {
                meta = 1 + this.seedMeta * 5;
                break;
            }
            case 5: {
                meta = 2 + this.seedMeta * 4;
                break;
            }
            case 6: {
                meta = 2 + this.seedMeta * 5;
                break;
            }
            case 7: {
                meta = 3 + this.seedMeta * 5;
            }
        }
        return this.getBlock().func_149691_a(0, meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderAsFlower() {
        return this.seedMeta == 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getInformation() {
        return "agricraft_journal." + (this.seedMeta == 0 ? "barleyNatura" : "cottonNatura");
    }
}

