/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import logisticspipes.items.LogisticsFluidContainer;
import logisticspipes.items.LogisticsItemCard;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.MinecraftColor;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class FluidContainerRenderer
implements IItemRenderer {
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private boolean useThis = true;
    private RenderItem renderItem;
    public static boolean skipNext;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (this.useThis && item != null) {
            if (item.func_77973_b() instanceof LogisticsFluidContainer) {
                switch (type) {
                    case ENTITY: {
                        return true;
                    }
                    case INVENTORY: {
                        return true;
                    }
                }
                return false;
            }
            if (item.func_77973_b() instanceof LogisticsItemCard) {
                switch (type) {
                    case INVENTORY: {
                        return Keyboard.isKeyDown((int)42);
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (skipNext) {
            skipNext = false;
            return;
        }
        GL11.glPushMatrix();
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (item.func_77973_b() instanceof LogisticsFluidContainer) {
            FluidStack liquid = SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(ItemIdentifierStack.getFromStack(item));
            if (type != IItemRenderer.ItemRenderType.INVENTORY && type != IItemRenderer.ItemRenderType.ENTITY || liquid == null) {
                this.doRenderItem(item, mc, type, data);
                GL11.glPopMatrix();
                return;
            }
            this.doRenderFluid(liquid, mc, type, data);
            this.doRenderItem(item, mc, type, data);
        } else if (item.func_77973_b() instanceof LogisticsItemCard) {
            this.doRenderItem(item, mc, type, data);
            NBTTagCompound nbt = item.func_77978_p();
            if (nbt == null || !nbt.func_74764_b("colors")) {
                GL11.glPopMatrix();
                return;
            }
            NBTTagCompound colors = nbt.func_74775_l("colors");
            if (colors == null) {
                GL11.glPopMatrix();
                return;
            }
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glScaled((double)0.07, (double)0.07, (double)1.0);
                GL11.glTranslated((double)-3.0, (double)3.5, (double)-0.025);
            }
            for (int i = 0; i < 6; ++i) {
                int colorCode = colors.func_74762_e("color:" + i);
                MinecraftColor color = MinecraftColor.values()[colorCode];
                int x = i / 3;
                int y = i % 3;
                if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                    Gui.func_73734_a((int)(x * 5 + 4), (int)(y * 3 + 3), (int)(x * 5 + 7), (int)(y * 3 + 5), (int)color.getColorCode());
                }
                if (type != IItemRenderer.ItemRenderType.ENTITY) continue;
                Gui.func_73734_a((int)(-x * 5 + 4), (int)(-y * 3 + 3), (int)(-x * 5 + 7), (int)(-y * 3 + 5), (int)color.getColorCode());
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                Gui.func_73734_a((int)(-x * 5 + 4), (int)(-y * 3 + 3), (int)(-x * 5 + 7), (int)(-y * 3 + 5), (int)color.getColorCode());
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
        }
        GL11.glPopMatrix();
    }

    public void doRenderFluid(FluidStack liquid, Minecraft mc, IItemRenderer.ItemRenderType type, Object[] data) {
        GL11.glPushMatrix();
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glRotatef((float)(((float)((EntityItem)data[1]).field_70292_b / 20.0f + ((EntityItem)data[1]).field_70290_d) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScaled((double)0.063, (double)0.065, (double)1.0);
            GL11.glTranslated((double)-8.0, (double)-4.0, (double)-0.02);
        }
        GL11.glDisable((int)2896);
        ResourceLocation resourcelocation = mc.field_71446_o.func_130087_a(liquid.getFluid().getSpriteNumber());
        mc.field_71446_o.func_110577_a(resourcelocation);
        int i1 = liquid.getFluid().getColor();
        float f = (float)(i1 >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i1 >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i1 & 0xFF) / 255.0f;
        GL11.glColor4f((float)f, (float)f1, (float)f2, (float)1.0f);
        IIcon icon = liquid.getFluid().getIcon();
        if (icon != null) {
            this.renderIcon(5, 2, icon, 6, 12, 0.0);
            if (type == IItemRenderer.ItemRenderType.ENTITY) {
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glRotatef((float)(((float)((EntityItem)data[1]).field_70292_b / 20.0f + ((EntityItem)data[1]).field_70290_d) * 57.295776f + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScaled((double)0.063, (double)0.065, (double)1.0);
                GL11.glTranslated((double)-8.0, (double)-4.0, (double)-0.042);
                this.renderIcon(5, 2, icon, 6, 12, 0.0);
            }
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public void renderIcon(int x, int y, IIcon par3Icon, int width, int height, double zLevel) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), zLevel, (double)par3Icon.func_94214_a((double)x), (double)par3Icon.func_94207_b((double)(y + height)));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), zLevel, (double)par3Icon.func_94214_a((double)(x + width)), (double)par3Icon.func_94207_b((double)(y + height)));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), zLevel, (double)par3Icon.func_94214_a((double)(x + width)), (double)par3Icon.func_94207_b((double)y));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), zLevel, (double)par3Icon.func_94214_a((double)x), (double)par3Icon.func_94207_b((double)y));
        tessellator.func_78381_a();
    }

    public void doRenderItem(ItemStack itemstack, Minecraft mc, IItemRenderer.ItemRenderType type, Object[] data) {
        this.useThis = false;
        if (this.renderItem == null) {
            this.renderItem = new RenderItem(){

                public boolean shouldBob() {
                    return false;
                }

                public boolean shouldSpreadItems() {
                    return false;
                }
            };
            this.renderItem.func_76976_a(RenderManager.field_78727_a);
        }
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderItem.func_82406_b(mc.field_71466_p, mc.field_71446_o, itemstack, 0, 0);
        } else {
            GL11.glPushMatrix();
            this.dummyEntityItem.func_92058_a(itemstack);
            this.dummyEntityItem.field_70290_d = 0.0f;
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            GL11.glRotatef((float)(((float)((EntityItem)data[1]).field_70292_b / 20.0f + ((EntityItem)data[1]).field_70290_d) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderItem.func_76986_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
        }
        this.useThis = true;
    }
}

