/*
 * Decompiled with CFR 0.152.
 */
package com.mia.ftbtrophies.events;

import com.mia.craftstudio.minecraft.client.CSClientModelWrapperVBO;
import com.mia.ftbtrophies.FTBTrophies;
import com.mia.ftbtrophies.TrophyModelMetadata;
import com.mia.ftbtrophies.common.ItemTrophies;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.Date;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.lwjgl.input.Keyboard;

public enum ClientEventHandler {
    INSTANCE;

    private int playerOrientation;
    private boolean canPlace;
    private CSClientModelWrapperVBO model = null;
    private int tx;
    private int ty;
    private int tz;
    private int tick = 0;
    private boolean setupNEI = true;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)INSTANCE);
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.itemStack.func_77973_b().equals(FTBTrophies.itemTrophies)) {
            boolean cheated = false;
            if (event.itemStack.func_77942_o()) {
                if (event.itemStack.func_77978_p().func_74764_b("uuid") && event.itemStack.func_77978_p().func_74764_b("time")) {
                    String name = UsernameCache.getLastKnownUsername((UUID)UUID.fromString(event.itemStack.func_77978_p().func_74779_i("uuid")));
                    String name2 = event.itemStack.func_77978_p().func_74779_i("user");
                    if (name == null) {
                        name = name2;
                    }
                    if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
                        event.toolTip.add(EnumChatFormatting.RESET.toString() + StatCollector.func_74837_a((String)"text.ftbtrophies.tooltip.playerobtainedachievment", (Object[])new Object[]{name, StatCollector.func_74838_a((String)event.itemStack.func_77978_p().func_74779_i("achid"))}));
                        event.toolTip.add(EnumChatFormatting.RESET.toString() + StatCollector.func_74837_a((String)"text.ftbtrophies.tooltip.receiveddate", (Object[])new Object[]{DateFormat.getDateInstance().format(new Date(event.itemStack.func_77978_p().func_74763_f("time")))}));
                    } else {
                        event.toolTip.add(EnumChatFormatting.RESET.toString() + StatCollector.func_74837_a((String)"text.ftbtrophies.tooltip.playerobtainedachievment.detailed", (Object[])new Object[]{name, name2, StatCollector.func_74838_a((String)event.itemStack.func_77978_p().func_74779_i("achid"))}));
                        event.toolTip.add(EnumChatFormatting.RESET.toString() + StatCollector.func_74837_a((String)"text.ftbtrophies.tooltip.receiveddate", (Object[])new Object[]{DateFormat.getDateTimeInstance(0, 2).format(new Date(event.itemStack.func_77978_p().func_74763_f("time")))}));
                        event.toolTip.add(EnumChatFormatting.RESET.toString() + StatCollector.func_74837_a((String)"text.ftbtrophies.tooltip.playerobtainedachievment.desc", (Object[])new Object[]{StatCollector.func_74838_a((String)(event.itemStack.func_77978_p().func_74779_i("achid") + ".desc"))}));
                    }
                } else {
                    cheated = true;
                }
            } else {
                cheated = true;
            }
            if (cheated) {
                event.toolTip.add(EnumChatFormatting.RESET.toString() + EnumChatFormatting.ITALIC.toString() + EnumChatFormatting.BOLD.toString() + StatCollector.func_74838_a((String)"text.ftbtrophies.cheated"));
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.tick++ % 4 == 0) {
            this.model = null;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            ItemStack currentItem = player.field_71071_by.func_70448_g();
            if (currentItem == null) {
                return;
            }
            if (!(currentItem.func_77973_b() instanceof ItemTrophies)) {
                return;
            }
            MovingObjectPosition target = Minecraft.func_71410_x().field_71476_x;
            if (target == null) {
                return;
            }
            if (target.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                return;
            }
            int meta = currentItem.func_77960_j();
            TrophyModelMetadata data = FTBTrophies.modelData.get(meta);
            this.playerOrientation = 0;
            if (!data.limitRotation) {
                this.playerOrientation = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
            } else {
                int direction = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                this.playerOrientation = direction * 4;
            }
            ForgeDirection fg = ForgeDirection.VALID_DIRECTIONS[target.field_72310_e];
            this.tx = target.field_72311_b + fg.offsetX;
            this.ty = target.field_72312_c + fg.offsetY;
            this.tz = target.field_72309_d + fg.offsetZ;
            this.canPlace = ItemTrophies.canPlace(data.wrapper, player.field_70170_p, this.tx, this.ty, this.tz, (EntityPlayer)player, this.playerOrientation);
            this.model = (CSClientModelWrapperVBO)FTBTrophies.modelData.get((Object)Integer.valueOf((int)meta)).wrapper;
        }
    }

    @SubscribeEvent
    public void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        if (this.model != null) {
            this.model.renderPlacement(event.player, event.partialTicks, this.canPlace, this.tx, this.ty, this.tz, this.playerOrientation);
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (this.setupNEI && Loader.isModLoaded((String)"NotEnoughItems")) {
            try {
                Class<?> neiAPI = Class.forName("codechicken.nei.api.API");
                Method hideItem = neiAPI.getDeclaredMethod("hideItem", ItemStack.class);
                NBTTagCompound WILDCARD_TAG = new NBTTagCompound();
                WILDCARD_TAG.func_74757_a("*", true);
                ItemStack hiddenTrophies = new ItemStack(FTBTrophies.itemTrophies, 1, Short.MAX_VALUE);
                hiddenTrophies.func_77982_d(WILDCARD_TAG);
                hideItem.invoke(null, hiddenTrophies);
                this.setupNEI = false;
            }
            catch (Throwable t) {
                FTBTrophies.log.warn("There was a problem integrating with NEI. This is non critical.");
            }
        }
    }
}

