/*
 * Decompiled with CFR 0.152.
 */
package com.mia.ftbtrophies;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.api.ICSProject;
import com.mia.craftstudio.minecraft.forge.CSLibMod;
import com.mia.ftbtrophies.TrophyModelMetadata;
import com.mia.ftbtrophies.common.BlockFake;
import com.mia.ftbtrophies.common.BlockTrophies;
import com.mia.ftbtrophies.common.ItemTrophies;
import com.mia.ftbtrophies.common.TileTrophyFake;
import com.mia.ftbtrophies.common.TileTypeMap;
import com.mia.ftbtrophies.events.CommonProxy;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="ftbtrophies", name="FTBTrophies", version="1.0.8", dependencies="after:props@[2.4.0,);required-after:PTRModelLib@[1.0.0,)")
public class FTBTrophies {
    @Mod.Instance(value="ftbtrophies")
    public static FTBTrophies instance;
    @SidedProxy(clientSide="com.mia.ftbtrophies.events.ClientProxy", serverSide="com.mia.ftbtrophies.events.CommonProxy")
    public static CommonProxy proxy;
    public static final String modid = "ftbtrophies";
    public static Logger log;
    public static Block blockTrophies;
    public static Block blockFake;
    public static Item itemTrophies;
    public static Map<Integer, TrophyModelMetadata> modelData;
    public static ICSProject csproject;

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        blockTrophies = new BlockTrophies();
        blockFake = new BlockFake();
        itemTrophies = new ItemTrophies();
        GameRegistry.registerBlock((Block)blockTrophies, (String)"blockTrophies");
        GameRegistry.registerBlock((Block)blockFake, (String)"blockFake");
        GameRegistry.registerItem((Item)itemTrophies, (String)"trophy");
        GameRegistry.registerTileEntity(TileTrophyFake.class, (String)"TileTrophyFake");
        TileTypeMap.register();
        this.loadModels();
        proxy.preInit();
    }

    private void validateModelMetadata(TrophyModelMetadata metaData, CSModel model) {
        if (modelData.containsKey(metaData.trophyID)) {
            TrophyModelMetadata existingMeta = modelData.get(metaData.trophyID);
            if (!existingMeta.craftstudioAssetName.equals(metaData.craftstudioAssetName)) {
                throw new RuntimeException("You gave a new model the same TrophyID as an existing model! Existing:[" + existingMeta.craftstudioAssetName + "], New:[" + metaData.craftstudioAssetName + "]");
            }
        }
        metaData.csmodel = model;
        metaData.validate();
        modelData.put(metaData.trophyID, metaData);
    }

    public void loadModels() {
        csproject = CSLibMod.getCSProjectAndLoad((String)"FTBTrophies");
        Gson gson = new GsonBuilder().create();
        for (Map.Entry entry : csproject.getModels().entrySet()) {
            JsonElement modelDescriptor = csproject.getDescriptor((Integer)entry.getKey());
            if (modelDescriptor == null) continue;
            this.validateModelMetadata((TrophyModelMetadata)((Object)gson.fromJson(modelDescriptor, TrophyModelMetadata.class)), (CSModel)entry.getValue());
        }
        proxy.setupModelWrappers();
    }

    public static TileEntity getTileEntityPreferNotCreating(IBlockAccess blockAccess, int x, int y, int z) {
        if (blockAccess instanceof World) {
            return FTBTrophies.getTileEntityWithoutCreating((World)blockAccess, x, y, z);
        }
        if (blockAccess instanceof ChunkCache) {
            return FTBTrophies.getTileEntityWithoutCreating(((ChunkCache)blockAccess).field_72815_e, x, y, z);
        }
        return blockAccess.func_147438_o(x, y, z);
    }

    public static TileEntity getTileEntityWithoutCreating(World world, int x, int y, int z) {
        if (world.func_72899_e(x, y, z)) {
            return world.func_72938_d(x, z).getTileEntityUnsafe(x & 0xF, y, z & 0xF);
        }
        return null;
    }

    static {
        log = LogManager.getLogger((String)modid);
        modelData = new HashMap<Integer, TrophyModelMetadata>(){

            @Override
            public TrophyModelMetadata get(Object key) {
                return super.containsKey(key) ? (TrophyModelMetadata)((Object)super.get(key)) : (TrophyModelMetadata)((Object)super.get(0));
            }
        };
    }
}

