/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.entity.SyncedCoordinate;
import mcjty.lib.entity.SyncedObject;
import mcjty.lib.entity.SyncedValue;
import mcjty.lib.entity.SyncedValueList;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.Coordinate;
import mcjty.rftools.blocks.storagemonitor.GuiStorageScanner;
import mcjty.rftools.blocks.storagemonitor.InvBlockInfo;
import mcjty.rftools.blocks.storagemonitor.StorageScannerConfiguration;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class StorageScannerTileEntity
extends GenericEnergyReceiverTileEntity {
    public static final String CMD_SETRADIUS = "setRadius";
    public static final String CMD_STARTSCAN = "startScan";
    public static final String CMD_STARTSEARCH = "startSearch";
    public static final String CLIENTCMD_SEARCHREADY = "searchReady";
    private List<ItemStack> showingItems = new ArrayList<ItemStack>();
    private SyncedValue<Integer> radius = new SyncedValue((Object)1);
    private SyncedValue<Boolean> scanning = new SyncedValue((Object)false);
    private SyncedCoordinate c1 = new SyncedCoordinate(Coordinate.INVALID);
    private SyncedCoordinate c2 = new SyncedCoordinate(Coordinate.INVALID);
    private SyncedCoordinate cur = new SyncedCoordinate(Coordinate.INVALID);
    private SyncedValueList<InvBlockInfo> inventories = new SyncedValueList<InvBlockInfo>(){

        public InvBlockInfo readElementFromNBT(NBTTagCompound tagCompound) {
            return InvBlockInfo.readFromNBT(tagCompound);
        }

        public NBTTagCompound writeElementToNBT(InvBlockInfo element) {
            return element.writeToNBT();
        }
    };

    public StorageScannerTileEntity() {
        super(StorageScannerConfiguration.MAXENERGY, StorageScannerConfiguration.RECEIVEPERTICK);
        this.registerSyncedObject((SyncedObject)this.scanning);
        this.registerSyncedObject((SyncedObject)this.c1);
        this.registerSyncedObject((SyncedObject)this.c2);
        this.registerSyncedObject((SyncedObject)this.cur);
        this.registerSyncedObject((SyncedObject)this.inventories);
    }

    public List<Coordinate> startSearch(String search) {
        search = search.toLowerCase();
        ArrayList<Coordinate> output = new ArrayList<Coordinate>();
        block0: for (InvBlockInfo invBlockInfo : this.inventories) {
            Coordinate c = invBlockInfo.getCoordinate();
            TileEntity tileEntity = this.field_145850_b.func_147438_o(c.getX(), c.getY(), c.getZ());
            if (!(tileEntity instanceof IInventory)) continue;
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                String readableName;
                ItemStack itemStack = inventory.func_70301_a(i);
                if (itemStack == null || !(readableName = itemStack.func_82833_r()).toLowerCase().contains(search)) continue;
                output.add(c);
                continue block0;
            }
        }
        return output;
    }

    public void startScan(boolean start) {
        if (!this.field_145850_b.field_72995_K) {
            if (!start) {
                this.scanning.setValue((Object)false);
                this.notifyBlockUpdate();
                return;
            }
            int r = (Integer)this.radius.getValue();
            int y1 = this.field_145848_d - r;
            if (y1 < 0) {
                y1 = 0;
            }
            this.c1.setCoordinate(new Coordinate(this.field_145851_c - r, y1, this.field_145849_e - r));
            int y2 = this.field_145848_d + r;
            if (y2 >= this.field_145850_b.func_72800_K()) {
                y2 = this.field_145850_b.func_72800_K() - 1;
            }
            this.c2.setCoordinate(new Coordinate(this.field_145851_c + r, y2, this.field_145849_e + r));
            this.scanning.setValue((Object)true);
            this.cur.setCoordinate(this.c1.getCoordinate());
            this.inventories.clear();
            this.notifyBlockUpdate();
        }
    }

    public int getRadius() {
        return (Integer)this.radius.getValue();
    }

    public void setRadius(int v) {
        this.radius.setValue((Object)v);
        this.notifyBlockUpdate();
    }

    public boolean isScanning() {
        return (Boolean)this.scanning.getValue();
    }

    public int getProgress() {
        int z1 = this.c1.getCoordinate().getZ();
        int z2 = this.c2.getCoordinate().getZ();
        int z = this.cur.getCoordinate().getZ();
        return (z - z1) * 100 / (z2 - z1);
    }

    protected void checkStateServer() {
        super.checkStateServer();
        if (((Boolean)this.scanning.getValue()).booleanValue()) {
            int rf = StorageScannerConfiguration.rfPerOperation;
            rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f);
            if (this.getEnergyStored(ForgeDirection.DOWN) < rf) {
                return;
            }
            this.consumeEnergy(rf);
            int scans = StorageScannerConfiguration.scansPerOperation;
            scans *= (int)(this.getInfusedFactor() + 1.01f);
            for (int i = 0; i < scans; ++i) {
                Coordinate c = this.cur.getCoordinate();
                this.checkInventoryStatus(c.getX(), c.getY(), c.getZ());
                if (this.advanceCurrent()) continue;
                return;
            }
        }
    }

    public void storeItemsForClient(List<ItemStack> items) {
        this.showingItems = new ArrayList<ItemStack>(items);
    }

    public List<ItemStack> getShowingItems() {
        return this.showingItems;
    }

    public void clearShowingItems() {
        this.showingItems.clear();
    }

    public List<ItemStack> getInventoryForBlock(int cx, int cy, int cz) {
        this.showingItems = new ArrayList<ItemStack>();
        if (this.getEnergyStored(ForgeDirection.DOWN) < StorageScannerConfiguration.rfPerOperation) {
            return this.showingItems;
        }
        this.consumeEnergy(StorageScannerConfiguration.rfPerOperation);
        TileEntity tileEntity = this.field_145850_b.func_147438_o(cx, cy, cz);
        if (tileEntity instanceof IInventory) {
            IInventory inventory = (IInventory)tileEntity;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack itemStack = inventory.func_70301_a(i);
                if (itemStack == null) continue;
                this.showingItems.add(itemStack);
            }
        }
        return this.showingItems;
    }

    private void checkInventoryStatus(int cx, int cy, int cz) {
        IInventory inventory;
        TileEntity tileEntity = this.field_145850_b.func_147438_o(cx, cy, cz);
        if (tileEntity instanceof IInventory && (inventory = (IInventory)tileEntity).func_70302_i_() > 0) {
            this.inventories.add((Object)new InvBlockInfo(new Coordinate(cx, cy, cz), inventory.func_70302_i_()));
            this.notifyBlockUpdate();
        }
    }

    private boolean advanceCurrent() {
        Coordinate c = this.cur.getCoordinate();
        int cx = c.getX();
        int cy = c.getY();
        int cz = c.getZ();
        Coordinate lo = this.c1.getCoordinate();
        Coordinate up = this.c2.getCoordinate();
        if (++cx > up.getX()) {
            cx = lo.getX();
            if (++cy > up.getY()) {
                cy = lo.getY();
                if (++cz > up.getZ()) {
                    this.scanning.setValue((Object)false);
                    this.notifyBlockUpdate();
                    return false;
                }
            }
        }
        this.cur.setCoordinate(new Coordinate(cx, cy, cz));
        this.notifyBlockUpdate();
        return true;
    }

    public SyncedValueList<InvBlockInfo> getInventories() {
        return this.inventories;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.scanning.setValue((Object)tagCompound.func_74767_n("scanning"));
        this.c1.readFromNBT(tagCompound, "c1");
        this.c2.readFromNBT(tagCompound, "c2");
        this.cur.readFromNBT(tagCompound, "cur");
        this.inventories.readFromNBT(tagCompound, "inv");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.radius.setValue((Object)tagCompound.func_74762_e("radius"));
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74757_a("scanning", ((Boolean)this.scanning.getValue()).booleanValue());
        this.c1.writeToNBT(tagCompound, "c1");
        this.c2.writeToNBT(tagCompound, "c2");
        this.cur.writeToNBT(tagCompound, "cur");
        this.inventories.writeToNBT(tagCompound, "inv");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("radius", ((Integer)this.radius.getValue()).intValue());
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETRADIUS.equals(command)) {
            this.setRadius(args.get("r").getInteger());
            return true;
        }
        if (CMD_STARTSCAN.equals(command)) {
            this.startScan(args.get("start").getBoolean());
            return true;
        }
        return false;
    }

    public List executeWithResultList(String command, Map<String, Argument> args) {
        List rc = super.executeWithResultList(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_STARTSEARCH.equals(command)) {
            return this.startSearch(args.get("search").getString());
        }
        return null;
    }

    public boolean execute(String command, List list) {
        boolean rc = super.execute(command, list);
        if (rc) {
            return true;
        }
        if (CLIENTCMD_SEARCHREADY.equals(command)) {
            GuiStorageScanner.fromServer_coordinates = new HashSet<Coordinate>(list);
            return true;
        }
        return false;
    }
}

