/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.special;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.rftools.blocks.special.SpecialSetup;
import mcjty.rftools.blocks.special.VolcanicEvents;
import mcjty.rftools.blocks.special.VolcanicRumbleSound;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class VolcanicCoreTileEntity
extends GenericTileEntity {
    private VolcanicRumbleSound sound = null;
    private int cycle = 500 + VolcanicEvents.random.nextInt(1500);

    protected void checkStateClient() {
        if (this.sound == null) {
            this.playRumble();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playRumble() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        this.sound = new VolcanicRumbleSound((EntityPlayer)player, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.sound);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.stopRumble();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopRumble() {
        if (this.sound != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.sound);
            this.sound = null;
        }
    }

    protected void checkStateServer() {
        ++this.cycle;
        this.func_70296_d();
        int c = this.cycle % 1500;
        float activityChance = c < 400 ? 1.0E-4f : (c < 600 ? 0.01f : (c < 800 ? 0.05f : (c < 1200 ? 0.01f : 1.0E-4f)));
        if (VolcanicEvents.random.nextFloat() < activityChance) {
            switch (VolcanicEvents.random.nextInt(16)) {
                case 0: {
                    VolcanicEvents.spawnVolcanicBlocks(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 7);
                    break;
                }
                case 1: 
                case 2: {
                    VolcanicEvents.explosion(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 7, 5.0f);
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    VolcanicEvents.randomFire(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 12);
                    break;
                }
                case 14: 
                case 15: {
                    VolcanicEvents.randomLava(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 1);
                    break;
                }
                default: {
                    this.spawnVolcanicBlock();
                }
            }
        }
    }

    private void spawnVolcanicBlock() {
        int rx = VolcanicEvents.random.nextInt(3) - 1;
        int ry = VolcanicEvents.random.nextInt(3) - 1;
        int rz = VolcanicEvents.random.nextInt(3) - 1;
        if (rx != 0 || ry != 0 || rz != 0) {
            int x = this.field_145851_c + rx;
            int y = this.field_145848_d + ry;
            int z = this.field_145849_e + rz;
            if (y < 0 || y >= this.field_145850_b.func_72800_K()) {
                return;
            }
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            if (block == null || block.func_149688_o() == Material.field_151579_a) {
                this.field_145850_b.func_147465_d(x, y, z, (Block)SpecialSetup.volcanicBlock, 15, 2);
            }
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.cycle = tagCompound.func_74762_e("cycle");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("cycle", this.cycle);
    }
}

