/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import java.util.List;
import mcjty.lib.api.Infusable;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.spaceprojector.BuilderContainer;
import mcjty.rftools.blocks.spaceprojector.BuilderTileEntity;
import mcjty.rftools.blocks.spaceprojector.GuiBuilder;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

@Optional.InterfaceList(value={@Optional.Interface(iface="crazypants.enderio.api.redstone.IRedstoneConnectable", modid="EnderIO")})
public class BuilderBlock
extends GenericRFToolsBlock
implements Infusable,
IRedstoneConnectable {
    private static long lastTime = 0L;

    public BuilderBlock() {
        super(Material.field_151573_f, BuilderTileEntity.class, true);
        this.func_149663_c("builderBlock");
        this.func_149647_a(RFTools.tabRfTools);
        this.setHorizRotation(true);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstoneWithTE(world, x, y, z);
    }

    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, ForgeDirection from) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This block is linked to a space chamber and");
            list.add(EnumChatFormatting.WHITE + "can move/copy/swap the blocks from the space chamber");
            list.add(EnumChatFormatting.WHITE + "to here. Insert a chamber card to make a link.");
            list.add(EnumChatFormatting.YELLOW + "Infusing bonus: reduced power consumption and");
            list.add(EnumChatFormatting.YELLOW + "increased building speed.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof BuilderTileEntity) {
            BuilderTileEntity builderTileEntity = (BuilderTileEntity)te;
            if (System.currentTimeMillis() - lastTime > 250L) {
                lastTime = System.currentTimeMillis();
                builderTileEntity.requestCurrentLevel();
            }
            int scan = builderTileEntity.getCurrentLevel();
            currenttip.add(EnumChatFormatting.GREEN + "Current level: " + (scan == -1 ? "not scanning" : Integer.valueOf(scan)));
        }
        return currenttip;
    }

    protected void rotateBlock(World world, int x, int y, int z) {
        BuilderTileEntity builderTileEntity;
        super.rotateBlock(world, x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof BuilderTileEntity && !world.field_72995_K && (builderTileEntity = (BuilderTileEntity)te).hasSupportMode()) {
            builderTileEntity.clearSupportBlocks();
            builderTileEntity.resetBox();
        }
    }

    public String getIdentifyingIconName() {
        return "machineBuilder";
    }

    public int getGuiID() {
        return RFTools.GUI_BUILDER;
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        BuilderTileEntity builderTileEntity = (BuilderTileEntity)tileEntity;
        BuilderContainer builderContainer = new BuilderContainer(entityPlayer, builderTileEntity);
        return new GuiBuilder(builderTileEntity, builderContainer);
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return new BuilderContainer(entityPlayer, (BuilderTileEntity)tileEntity);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        BuilderTileEntity builderTileEntity;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof BuilderTileEntity && !world.field_72995_K && (builderTileEntity = (BuilderTileEntity)te).hasSupportMode()) {
            builderTileEntity.clearSupportBlocks();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }
}

