/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.Coordinate;
import mcjty.rftools.blocks.screens.ModelScreen;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcjty.rftools.blocks.screens.modulesclient.ClientScreenModule;
import mcjty.rftools.blocks.screens.network.PacketGetScreenData;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ScreenRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation texture = new ResourceLocation("rftools", "textures/blocks/screenFrame.png");
    private final ModelScreen screenModel = new ModelScreen(0);
    private final ModelScreen screenModelLarge = new ModelScreen(1);
    private final ModelScreen screenModelHuge = new ModelScreen(2);

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        GL11.glPushAttrib((int)270657);
        GL11.glPushMatrix();
        int meta = tileEntity.func_145832_p();
        float f3 = 0.0f;
        if (meta == 2) {
            f3 = 180.0f;
        }
        if (meta == 4) {
            f3 = 90.0f;
        }
        if (meta == 5) {
            f3 = -90.0f;
        }
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        GL11.glRotatef((float)(-f3), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)-0.4375f);
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)tileEntity;
        if (!screenTileEntity.isTransparent()) {
            GL11.glDisable((int)2896);
            this.renderScreenBoard(screenTileEntity.getSize(), screenTileEntity.getColor());
        }
        if (screenTileEntity.isPowerOn()) {
            FontRenderer fontrenderer = this.func_147498_b();
            ClientScreenModule.TransformMode mode = ClientScreenModule.TransformMode.NONE;
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2896);
            Map<Integer, Object[]> screenData = this.updateScreenData(screenTileEntity);
            List<ClientScreenModule> modules = screenTileEntity.getClientScreenModules();
            this.renderModules(fontrenderer, mode, modules, screenData, screenTileEntity.getSize());
        }
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private Map<Integer, Object[]> updateScreenData(ScreenTileEntity screenTileEntity) {
        Map screenData;
        long millis = System.currentTimeMillis();
        if (millis - screenTileEntity.lastTime > 500L && screenTileEntity.isNeedsServerData()) {
            screenTileEntity.lastTime = millis;
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGetScreenData(screenTileEntity.field_145851_c, screenTileEntity.field_145848_d, screenTileEntity.field_145849_e, millis));
        }
        if ((screenData = ScreenTileEntity.screenData.get(new Coordinate(screenTileEntity.field_145851_c, screenTileEntity.field_145848_d, screenTileEntity.field_145849_e))) == null) {
            screenData = Collections.EMPTY_MAP;
        }
        return screenData;
    }

    private void renderModules(FontRenderer fontrenderer, ClientScreenModule.TransformMode mode, List<ClientScreenModule> modules, Map<Integer, Object[]> screenData, int size) {
        float factor = (float)size + 1.0f;
        int currenty = 7;
        int moduleIndex = 0;
        for (ClientScreenModule module : modules) {
            int height;
            if (module != null && currenty + (height = module.getHeight()) <= 124) {
                if (module.getTransformMode() != mode) {
                    if (mode != ClientScreenModule.TransformMode.NONE) {
                        GL11.glPopMatrix();
                    }
                    GL11.glPushMatrix();
                    mode = module.getTransformMode();
                    switch (mode) {
                        case TEXT: {
                            GL11.glTranslatef((float)-0.5f, (float)0.5f, (float)0.07f);
                            float f3 = 0.0075f;
                            GL11.glScalef((float)(f3 * factor), (float)(-f3 * factor), (float)f3);
                            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            break;
                        }
                        case TEXTLARGE: {
                            GL11.glTranslatef((float)-0.5f, (float)0.5f, (float)0.07f);
                            float f3 = 0.015f;
                            GL11.glScalef((float)(f3 * factor), (float)(-f3 * factor), (float)f3);
                            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
                            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            break;
                        }
                        case ITEM: {
                            break;
                        }
                    }
                }
                module.render(fontrenderer, currenty, screenData.get(moduleIndex), factor);
                currenty += height;
            }
            ++moduleIndex;
        }
        if (mode != ClientScreenModule.TransformMode.NONE) {
            GL11.glPopMatrix();
        }
    }

    private void renderScreenBoard(int size, int color) {
        this.func_147499_a(texture);
        GL11.glPushMatrix();
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        if (size == 2) {
            this.screenModelHuge.render();
        } else if (size == 1) {
            this.screenModelLarge.render();
        } else {
            this.screenModel.render();
        }
        GL11.glDepthMask((boolean)false);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78380_c(240);
        tessellator.func_78384_a(color, 255);
        float r = size == 2 ? 2.46f : (size == 1 ? 1.46f : 0.46f);
        tessellator.func_78377_a((double)-0.46f, (double)r, (double)-0.08f);
        tessellator.func_78377_a((double)r, (double)r, (double)-0.08f);
        tessellator.func_78377_a((double)r, (double)-0.46f, (double)-0.08f);
        tessellator.func_78377_a((double)-0.46f, (double)-0.46f, (double)-0.08f);
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }
}

