/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.FileVersion;
import hardcorequesting.QuestingData;
import hardcorequesting.SaveHelper;
import hardcorequesting.Translator;
import hardcorequesting.client.EditMode;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.client.interfaces.GuiEditMenuItem;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestDataTask;
import hardcorequesting.quests.QuestDataTaskItems;
import hardcorequesting.quests.QuestTask;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

public abstract class QuestTaskItems
extends QuestTask {
    ItemRequirement[] items;
    private static final int MAX_X = 300;
    private static final int OFFSET = 20;
    private static final int SIZE = 18;
    private static final int TEXT_HEIGHT = 9;

    public QuestTaskItems(Quest parent, String description, String longDescription) {
        super(parent, description, longDescription);
        this.setItems(new ItemRequirement[0]);
    }

    public void setItems(ItemRequirement[] items) {
        this.items = items;
        this.setPositions(this.items);
    }

    public ItemRequirement[] getItems() {
        return this.items;
    }

    public void setItem(GuiEditMenuItem.Element element, int id, ItemPrecision precision) {
        if (element.getItem() == null) {
            return;
        }
        if (id >= this.items.length) {
            this.items = this.getEditFriendlyItems(this.items);
            SaveHelper.add(SaveHelper.EditType.TASK_ITEM_CREATE);
        } else {
            SaveHelper.add(SaveHelper.EditType.TASK_ITEM_CHANGE);
        }
        if (id < this.items.length) {
            if (element instanceof GuiEditMenuItem.ElementItem) {
                GuiEditMenuItem.ElementItem item = (GuiEditMenuItem.ElementItem)element;
                this.items[id].hasItem = true;
                this.items[id].fluid = null;
                ItemStack itemStack = ((ItemStack)item.getItem()).func_77946_l();
                itemStack.field_77994_a = 1;
                this.items[id].item = itemStack;
            } else {
                GuiEditMenuItem.ElementFluid fluid = (GuiEditMenuItem.ElementFluid)element;
                this.items[id].hasItem = false;
                this.items[id].fluid = (Fluid)fluid.getItem();
                this.items[id].item = null;
            }
            this.items[id].required = Math.min(DataBitHelper.ITEM_PROGRESS.getMaximum(), element.getAmount());
            this.items[id].precision = precision;
            ItemRequirement.access$202(this.items[id], null);
        }
    }

    private int getProgress(EntityPlayer player, int id) {
        if (id >= this.items.length) {
            return 0;
        }
        QuestDataTaskItems data = (QuestDataTaskItems)this.getData(player);
        if (id >= data.progress.length) {
            data.progress = Arrays.copyOf(data.progress, data.progress.length + 1);
        }
        return data.progress[id];
    }

    protected void resetTask(String playerName, int id) {
        this.getData((String)playerName).completed = false;
        ((QuestDataTaskItems)this.getData((String)playerName)).progress[id] = 0;
    }

    protected void completeTask(String playerName, int id, int count) {
        QuestDataTaskItems data = (QuestDataTaskItems)this.getData(playerName);
        data.progress[id] = count;
        this.doCompletionCheck(data, playerName);
    }

    private void setPositions(ItemRequirement[] items) {
        int x = 180;
        int y = 95;
        for (ItemRequirement item : items) {
            item.x = x;
            item.y = y;
            if ((x += 20) <= 300) continue;
            x = 180;
            y += 20;
        }
    }

    @Override
    public void read(DataReader dr, QuestDataTask task, FileVersion version, boolean light) {
        super.read(dr, task, version, light);
        if (light) {
            for (int i = 0; i < this.items.length; ++i) {
                ((QuestDataTaskItems)task).progress[i] = dr.readData(DataBitHelper.ITEM_PROGRESS);
            }
        } else {
            int count = dr.readData(DataBitHelper.TASK_ITEM_COUNT);
            for (int i = 0; i < count; ++i) {
                int progress = dr.readData(DataBitHelper.ITEM_PROGRESS);
                if (i >= ((QuestDataTaskItems)task).progress.length) continue;
                ((QuestDataTaskItems)task).progress[i] = Math.min(this.items[i].required, Math.max(0, progress));
            }
        }
    }

    @Override
    public void write(DataWriter dw, QuestDataTask task, boolean light) {
        super.write(dw, task, light);
        if (!light) {
            dw.writeData(this.items.length, DataBitHelper.TASK_ITEM_COUNT);
        }
        for (int i = 0; i < this.items.length; ++i) {
            dw.writeData(((QuestDataTaskItems)task).progress[i], DataBitHelper.ITEM_PROGRESS);
        }
    }

    @Override
    public void save(DataWriter dw) {
        dw.writeData(this.items.length, DataBitHelper.TASK_ITEM_COUNT);
        for (ItemRequirement item : this.items) {
            dw.writeBoolean(item.hasItem);
            if (item.hasItem) {
                dw.writeItem(item.item.func_77973_b());
                dw.writeData(item.item.func_77960_j(), DataBitHelper.SHORT);
                dw.writeNBT(item.item.func_77978_p());
                dw.writeData(item.required, DataBitHelper.TASK_REQUIREMENT);
                dw.writeString(ItemPrecision.getUniqueID(item.precision), DataBitHelper.ITEM_PRECISION);
                continue;
            }
            FluidStack fluidStack = new FluidStack(item.fluid, item.required);
            NBTTagCompound compound = new NBTTagCompound();
            fluidStack.writeToNBT(compound);
            dw.writeNBT(compound);
        }
    }

    @Override
    public void load(DataReader dr, FileVersion version) {
        int count = dr.readData(DataBitHelper.TASK_ITEM_COUNT);
        ItemRequirement[] items = new ItemRequirement[count];
        for (int i = 0; i < items.length; ++i) {
            boolean isItem = dr.readBoolean();
            if (isItem) {
                Item item = dr.readItem();
                if (Quest.isEditing && item == null) {
                    FMLLog.log((String)"HQM-EDIT", (Level)Level.INFO, (String)"Changed invalid item to bedrock.", (Object[])new Object[0]);
                    item = Item.func_150898_a((Block)Blocks.field_150357_h);
                }
                int dmg = dr.readData(DataBitHelper.SHORT);
                NBTTagCompound compound = dr.readNBT();
                ItemStack itemStack = new ItemStack(item, 1, dmg);
                itemStack.func_77982_d(compound);
                items[i] = new ItemRequirement(itemStack, dr.readData(DataBitHelper.TASK_REQUIREMENT));
                items[i].precision = version.lacks(FileVersion.CUSTOM_PRECISION_TYPES) ? ItemPrecision.getOldPrecisionType(dr.readData(DataBitHelper.ITEM_PRECISION)) : ItemPrecision.getPrecisionType(dr.readString(DataBitHelper.ITEM_PRECISION));
                continue;
            }
            NBTTagCompound compound = dr.readNBT();
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound);
            if (fluidStack == null) continue;
            items[i] = new ItemRequirement(fluidStack.getFluid(), fluidStack.amount);
        }
        this.setItems(items);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, EntityPlayer player, int mX, int mY) {
        String str;
        ItemRequirement item;
        int i;
        ItemRequirement[] items = this.getEditFriendlyItems(this.items);
        for (i = 0; i < items.length; ++i) {
            item = items[i];
            if (item.hasItem) {
                gui.drawItem(item.getPermutatedItem(), item.x, item.y, mX, mY, false);
            } else {
                gui.drawFluid(item.fluid, item.x, item.y, mX, mY);
            }
            str = this.getProgress(player, i) * 100 / item.required + "%";
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
            float textSize = 0.8f;
            gui.drawStringWithShadow(str, (int)((float)(item.x + 18) - (float)gui.getStringWidth(str) * textSize), (int)((float)(item.y + 18) - 9.0f * textSize + 2.0f), textSize, this.getProgress(player, i) == item.required ? 0x308030 : 0xFFFFFF);
            GL11.glPopMatrix();
        }
        for (i = 0; i < items.length; ++i) {
            item = items[i];
            if (!gui.inBounds(item.x, item.y, 18, 18, mX, mY)) continue;
            GuiQuestBook.setSelected(item.getItem());
            str = "";
            if (this.getProgress(player, i) == item.required) {
                str = str + (Object)((Object)GuiColor.GREEN);
            }
            str = str + item.getDisplayName() + ": " + this.getProgress(player, i) + "/" + item.required;
            if (Quest.isEditing) {
                str = str + "\n" + (Object)((Object)GuiColor.GRAY) + item.getPrecision().getName();
            }
            if (gui.isOpBook && GuiScreen.func_146272_n()) {
                str = this.isCompleted(player) ? str + "\n\n" + (Object)((Object)GuiColor.RED) + Translator.translate("hqm.questBook.resetTask") : str + "\n\n" + (Object)((Object)GuiColor.ORANGE) + Translator.translate("hqm.questBook.completeTask");
            }
            gui.drawMouseOver(str, mX + gui.getLeft(), mY + gui.getTop());
            break;
        }
    }

    private ItemRequirement[] getEditFriendlyItems(ItemRequirement[] items) {
        if (!Quest.isEditing || items.length >= DataBitHelper.TASK_ITEM_COUNT.getMaximum()) {
            return items;
        }
        items = Arrays.copyOf(items, items.length + 1);
        items[items.length - 1] = new ItemRequirement((ItemStack)null, 1);
        this.setPositions(items);
        return items;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClick(GuiQuestBook gui, EntityPlayer player, int mX, int mY, int b) {
        if (Quest.isEditing) {
            ItemRequirement[] items = this.getEditFriendlyItems(this.items);
            for (int i = 0; i < items.length; ++i) {
                ItemRequirement item = items[i];
                if (!gui.inBounds(item.x, item.y, 18, 18, mX, mY)) continue;
                if (gui.getCurrentMode() == EditMode.ITEM) {
                    gui.setEditMenu(new GuiEditMenuItem((GuiBase)gui, player, item.hasItem ? (item.item != null ? item.item.func_77946_l() : null) : item.fluid, i, this.getMenuTypeId(), item.required, item.precision));
                    break;
                }
                if (gui.getCurrentMode() == EditMode.DELETE && (item.item != null || item.fluid != null)) {
                    ItemRequirement[] newItems = new ItemRequirement[this.items.length - 1];
                    int id = 0;
                    for (int j = 0; j < this.items.length; ++j) {
                        if (j == i) continue;
                        newItems[id] = this.items[j];
                        ++id;
                    }
                    this.setItems(newItems);
                    SaveHelper.add(SaveHelper.EditType.TASK_ITEM_REMOVE);
                    break;
                }
                if (!gui.isOpBook || !GuiScreen.func_146272_n()) break;
                if (this.isCompleted(player)) {
                    this.resetTask(QuestingData.getUserName(player), i);
                    break;
                }
                this.completeTask(QuestingData.getUserName(player), i, item.required);
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract GuiEditMenuItem.Type getMenuTypeId();

    public boolean increaseItems(ItemStack[] itemsToConsume, QuestDataTaskItems data, String playerName) {
        if (!this.parent.isAvailable(playerName)) {
            return false;
        }
        boolean updated = false;
        for (int i = 0; i < this.items.length; ++i) {
            ItemRequirement item = this.items[i];
            if (!item.hasItem || item.required == data.progress[i]) continue;
            for (int j = 0; j < itemsToConsume.length; ++j) {
                int amount;
                ItemStack itemStack = itemsToConsume[j];
                if (!item.precision.areItemsSame(itemStack, item.item) || (amount = Math.min(itemStack.field_77994_a, item.required - data.progress[i])) <= 0) continue;
                itemStack.field_77994_a -= amount;
                if (itemStack.field_77994_a == 0) {
                    itemsToConsume[j] = null;
                }
                int n = i;
                data.progress[n] = data.progress[n] + amount;
                updated = true;
            }
        }
        if (updated) {
            this.doCompletionCheck(data, playerName);
        }
        return updated;
    }

    protected void doCompletionCheck(QuestDataTaskItems data, String playerName) {
        boolean isDone = true;
        for (int i = 0; i < this.items.length; ++i) {
            ItemRequirement item = this.items[i];
            if (item.required <= data.progress[i]) continue;
            isDone = false;
            break;
        }
        if (isDone) {
            this.completeTask(playerName);
        }
        this.parent.sendUpdatedDataToTeam(playerName);
    }

    @Override
    public Class<? extends QuestDataTask> getDataType() {
        return QuestDataTaskItems.class;
    }

    @Override
    public float getCompletedRatio(String playerName) {
        QuestDataTaskItems data = (QuestDataTaskItems)this.getData(playerName);
        int done = 0;
        int total = 0;
        for (int count : data.progress) {
            done += count;
        }
        for (ItemRequirement item : this.items) {
            total += item.required;
        }
        return Math.max(0.0f, Math.min(1.0f, (float)done / (float)total));
    }

    @Override
    public void mergeProgress(String playerName, QuestDataTask own, QuestDataTask other) {
        int[] ownProgress = ((QuestDataTaskItems)own).progress;
        int[] otherProgress = ((QuestDataTaskItems)other).progress;
        boolean completed = true;
        for (int i = 0; i < ownProgress.length; ++i) {
            ownProgress[i] = Math.max(ownProgress[i], otherProgress[i]);
            if (ownProgress[i] == this.items[i].required) continue;
            completed = false;
        }
        if (completed) {
            this.completeTask(playerName);
        }
    }

    @Override
    public void copyProgress(QuestDataTask own, QuestDataTask other) {
        super.copyProgress(own, other);
        int[] ownProgress = ((QuestDataTaskItems)own).progress;
        int[] otherProgress = ((QuestDataTaskItems)other).progress;
        System.arraycopy(otherProgress, 0, ownProgress, 0, ownProgress.length);
    }

    @Override
    public void autoComplete(String playerName) {
        QuestDataTaskItems data = (QuestDataTaskItems)this.getData(playerName);
        for (int i = 0; i < this.items.length; ++i) {
            data.progress[i] = this.items[i].required;
        }
    }

    public static class ItemRequirement {
        private ItemStack item;
        public Fluid fluid;
        public int required;
        public boolean hasItem;
        private ItemPrecision precision = ItemPrecision.PRECISE;
        private ItemStack[] permutations;
        private int cycleAt = -1;
        private int current = 0;
        private int last;
        private static int CYCLE_TIME = 2;
        private int x;
        private int y;

        public ItemRequirement(ItemStack item, int required) {
            this.item = item;
            this.required = required;
            this.hasItem = true;
        }

        public ItemRequirement(Fluid fluid, int required) {
            this.fluid = fluid;
            this.required = required;
            this.hasItem = false;
        }

        public ItemPrecision getPrecision() {
            return this.precision;
        }

        public void setPrecision(ItemPrecision precision) {
            this.precision = precision;
            this.permutations = null;
        }

        public ItemStack getItem() {
            return this.item;
        }

        public void setItem(ItemStack item) {
            this.item = item;
            this.permutations = null;
        }

        private void setPermutations() {
            if (this.item == null) {
                return;
            }
            this.permutations = this.precision.getPermutations(this.item);
            if (this.permutations != null && this.permutations.length > 0) {
                this.last = this.permutations.length - 1;
                this.cycleAt = -1;
            }
        }

        public ItemStack getPermutatedItem() {
            if (this.permutations == null && this.precision.hasPermutations()) {
                this.setPermutations();
            }
            if (this.permutations == null || this.permutations.length < 2) {
                return this.item;
            }
            int ticks = (int)(System.currentTimeMillis() / 1000L);
            if (this.cycleAt == -1) {
                this.cycleAt = ticks + CYCLE_TIME;
            }
            if (ticks >= this.cycleAt) {
                if (++this.current > this.last) {
                    this.current = 0;
                }
                while (ticks >= this.cycleAt) {
                    this.cycleAt += CYCLE_TIME;
                }
            }
            return this.permutations[this.current];
        }

        public String getDisplayName() {
            ItemStack item = this.getPermutatedItem();
            if (this.hasItem && item == null) {
                return "Nothing";
            }
            if (item != null) {
                return item.func_77973_b() != null ? item.func_82833_r() : "Unknown";
            }
            return this.fluid.getLocalizedName(null);
        }

        static /* synthetic */ ItemStack[] access$202(ItemRequirement x0, ItemStack[] x1) {
            x0.permutations = x1;
            return x1;
        }
    }
}

