/*
 * Decompiled with CFR 0.152.
 */
package tterrag.customthings.common.handlers;

import com.enderio.core.common.Handlers;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import tterrag.customthings.common.config.json.items.RecordType;

@Handlers.Handler
public class LivingDropsHandler {
    private static final Random rand = new Random();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDrop(LivingDropsEvent event) {
        if (event.entityLiving instanceof EntityCreeper) {
            boolean foundRecord = false;
            for (EntityItem e : event.drops) {
                if (!(e.func_92059_d().func_77973_b() instanceof ItemRecord)) continue;
                foundRecord = true;
            }
            if (foundRecord) {
                this.addRandomRecordToDrops(event.drops);
            }
        }
    }

    private void addRandomRecordToDrops(ArrayList<EntityItem> drops) {
        ArrayList<EntityItem> temp = new ArrayList<EntityItem>();
        temp.addAll(drops);
        drops.clear();
        for (EntityItem item : temp) {
            if (item.func_92059_d().func_77973_b() instanceof ItemRecord) {
                ItemStack record;
                int max = 12 + RecordType.getLootRecordCount();
                int random = rand.nextInt(max);
                if (random < 12) {
                    int id = Item.func_150891_b((Item)Items.field_151096_cd) + random;
                    record = new ItemStack(Item.func_150899_d((int)id));
                } else {
                    record = this.getDroppableRecord(random -= 12);
                }
                EntityItem entity = new EntityItem(item.field_70170_p, item.field_70165_t, item.field_70163_u, item.field_70161_v, record);
                drops.add(entity);
                continue;
            }
            drops.add(item);
        }
    }

    private ItemStack getDroppableRecord(int random) {
        if (RecordType.getType((int)random).isCreeperLoot) {
            return new ItemStack(RecordType.getItem(random));
        }
        return this.getDroppableRecord(rand.nextInt(RecordType.getNumRecords()));
    }
}

