/*
 * Decompiled with CFR 0.152.
 */
package tterrag.customthings.common.config.json;

import com.enderio.core.common.util.ItemUtil;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import tterrag.customthings.common.block.BlockCustom;
import tterrag.customthings.common.block.BlockCustomFalling;
import tterrag.customthings.common.block.BlockCustomFence;
import tterrag.customthings.common.block.BlockCustomSlab;
import tterrag.customthings.common.block.BlockCustomStairs;
import tterrag.customthings.common.block.BlockCustomWall;
import tterrag.customthings.common.block.IBlockCustom;
import tterrag.customthings.common.config.json.JsonType;
import tterrag.customthings.common.item.ItemBlockCustom;
import tterrag.customthings.common.item.ItemBlockCustomSlab;

public class BlockType
extends JsonType {
    public String type = "rock";
    public float hardness = 0.3f;
    public float resistance = 0.5f;
    public int harvestLevel = 0;
    public String toolType = "";
    public String[] drops = new String[0];
    public int minXp = 0;
    public int maxXp = 0;
    public String[] textureMap = null;
    public String[] oreDictNames = null;
    public boolean isOpaque = true;
    public String shape = "normal";
    public int lightLevel = 0;
    public int maxStackSize = 64;
    public int burnTime = 0;
    private transient DropData[] stackDrops;
    private transient BlockData data;
    private static Multimap<BlockData, BlockType> blockTypes = LinkedHashMultimap.create();
    private static int meta = 0;

    @Override
    public void register() {
        this.initData();
        this.lightLevel = MathHelper.func_76125_a((int)this.lightLevel, (int)0, (int)15);
        this.maxStackSize = MathHelper.func_76125_a((int)this.maxStackSize, (int)1, (int)64);
        this.burnTime = Math.max(0, this.burnTime);
        blockTypes.get((Object)this.data).add(this);
    }

    private void initData() {
        MaterialSound ms = null;
        BlockShape bs = null;
        try {
            ms = MaterialSound.valueOf(this.type.toUpperCase(Locale.ENGLISH));
            bs = BlockShape.valueOf(this.shape.toUpperCase(Locale.ENGLISH));
            this.data = new BlockData(ms, bs, this.isOpaque);
        }
        catch (IllegalArgumentException e) {
            if (ms == null) {
                throw new RuntimeException(this.type + " is not a valid block type. Valid types are: " + Arrays.toString((Object[])MaterialSound.values()), e);
            }
            throw new RuntimeException(this.shape + " is not a valid shape. Value shapes are: " + Arrays.toString((Object[])BlockShape.values()), e);
        }
    }

    @Override
    public void postInit() {
        this.stackDrops = new DropData[this.drops.length];
        for (int i = 0; i < this.drops.length; ++i) {
            String drop = this.drops[i];
            if (drop.indexOf(35) == -1 || drop.indexOf(45) == -1) {
                ItemStack stack = ItemUtil.parseStringIntoItemStack((String)this.drops[i]);
                this.stackDrops[i] = new DropData(stack, stack.field_77994_a, stack.field_77994_a);
                continue;
            }
            String range = this.drops[i].substring(drop.indexOf(35) + 1, drop.length());
            String[] minmax = range.split("\\-");
            try {
                ItemStack stack = ItemUtil.parseStringIntoItemStack((String)this.drops[i].substring(0, drop.indexOf(35)));
                this.stackDrops[i] = new DropData(stack, Integer.valueOf(minmax[0]), Integer.valueOf(minmax[1]));
                continue;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Could not parse drop amount range for block " + this.name, e);
            }
        }
    }

    public static void registerBlocks() {
        int blockNum = 0;
        for (BlockData d : blockTypes.keySet()) {
            Collection blocks = blockTypes.get((Object)d);
            if (blocks.isEmpty()) continue;
            Object realBlock = d.getShape().create(d);
            for (BlockType block : blocks) {
                realBlock.setType(block, meta++);
                if (meta < realBlock.getMaxTypes()) continue;
                BlockType.registerBlock(d, realBlock, blockNum++);
                realBlock = d.getShape().create(d);
                meta = 0;
            }
            if (meta != 0) {
                BlockType.registerBlock(d, realBlock, blockNum++);
            }
            meta = 0;
        }
    }

    private static void registerBlock(BlockData data, IBlockCustom block, int index) {
        data.getShape().registerBlock(block, index);
        for (int i = 0; i < block.getTypes().length; ++i) {
            BlockType type = block.getTypes()[i];
            if (type == null) continue;
            ItemStack stack = new ItemStack((Block)block, 1, i);
            OreDictionary.registerOre((String)("block" + StringUtils.capitalize((String)type.name)), (ItemStack)stack);
            if (type.oreDictNames == null) continue;
            for (String s : type.oreDictNames) {
                OreDictionary.registerOre((String)s, (ItemStack)stack);
            }
        }
    }

    public ArrayList<ItemStack> getStackDrops() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.stackDrops == null) {
            return stacks;
        }
        for (DropData data : this.stackDrops) {
            ItemStack stack = data.stack.func_77946_l();
            stack.field_77994_a = data.getRandomStackSize();
            stacks.add(stack);
        }
        return stacks;
    }

    private static final class DropData {
        private static final Random rand = new Random();
        private final ItemStack stack;
        private final int min;
        private final int max;

        public int getRandomStackSize() {
            return rand.nextInt(this.max - this.min + 1) + this.min;
        }

        @ConstructorProperties(value={"stack", "min", "max"})
        public DropData(ItemStack stack, int min, int max) {
            this.stack = stack;
            this.min = min;
            this.max = max;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DropData)) {
                return false;
            }
            DropData other = (DropData)o;
            ItemStack this$stack = this.getStack();
            ItemStack other$stack = other.getStack();
            if (this$stack == null ? other$stack != null : !this$stack.equals(other$stack)) {
                return false;
            }
            if (this.getMin() != other.getMin()) {
                return false;
            }
            return this.getMax() == other.getMax();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ItemStack $stack = this.getStack();
            result = result * 59 + ($stack == null ? 43 : $stack.hashCode());
            result = result * 59 + this.getMin();
            result = result * 59 + this.getMax();
            return result;
        }

        public String toString() {
            return "BlockType.DropData(stack=" + this.getStack() + ", min=" + this.getMin() + ", max=" + this.getMax() + ")";
        }
    }

    public static final class BlockData {
        private final MaterialSound type;
        private final BlockShape shape;
        private final boolean isOpaque;

        @ConstructorProperties(value={"type", "shape", "isOpaque"})
        public BlockData(MaterialSound type, BlockShape shape, boolean isOpaque) {
            this.type = type;
            this.shape = shape;
            this.isOpaque = isOpaque;
        }

        public MaterialSound getType() {
            return this.type;
        }

        public BlockShape getShape() {
            return this.shape;
        }

        public boolean isOpaque() {
            return this.isOpaque;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlockData)) {
                return false;
            }
            BlockData other = (BlockData)o;
            MaterialSound this$type = this.getType();
            MaterialSound other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            BlockShape this$shape = this.getShape();
            BlockShape other$shape = other.getShape();
            if (this$shape == null ? other$shape != null : !((Object)((Object)this$shape)).equals((Object)other$shape)) {
                return false;
            }
            return this.isOpaque() == other.isOpaque();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            MaterialSound $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            BlockShape $shape = this.getShape();
            result = result * 59 + ($shape == null ? 43 : ((Object)((Object)$shape)).hashCode());
            result = result * 59 + (this.isOpaque() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "BlockType.BlockData(type=" + (Object)((Object)this.getType()) + ", shape=" + (Object)((Object)this.getShape()) + ", isOpaque=" + this.isOpaque() + ")";
        }
    }

    public static enum BlockShape {
        NORMAL(BlockCustom.class),
        SLAB(BlockCustomSlab.class){

            @Override
            public void registerBlock(IBlockCustom block, int index) {
                BlockCustomSlab slab = (BlockCustomSlab)block;
                GameRegistry.registerBlock((Block)slab, ItemBlockCustomSlab.class, (String)("block" + index), (Object[])new Object[]{false});
            }
        }
        ,
        STAIR(BlockCustomStairs.class),
        FALLING(BlockCustomFalling.class),
        FENCE(BlockCustomFence.class),
        WALL(BlockCustomWall.class);

        public final Class<? extends IBlockCustom> clazz;

        public <T extends IBlockCustom> T create(BlockData data) {
            return (T)this.clazz.getConstructor(BlockData.class).newInstance(data);
        }

        public void registerBlock(IBlockCustom block, int index) {
            GameRegistry.registerBlock((Block)((Block)block), ItemBlockCustom.class, (String)("block" + index));
        }

        private BlockShape(Class<? extends IBlockCustom> clazz) {
            this.clazz = clazz;
        }
    }

    public static enum MaterialSound {
        ROCK(Material.field_151576_e, Block.field_149769_e),
        DIRT(Material.field_151578_c, Block.field_149767_g),
        WOOD(Material.field_151575_d, Block.field_149766_f),
        METAL(Material.field_151573_f, Block.field_149777_j),
        GRASS(Material.field_151577_b, Block.field_149779_h),
        GLASS(Material.field_151592_s, Block.field_149778_k),
        WOOL(Material.field_151580_n, Block.field_149775_l),
        LEAF(Material.field_151584_j, Block.field_149779_h),
        SNOW(Material.field_151597_y, Block.field_149773_n);

        public final Material material;
        public final Block.SoundType sound;

        private MaterialSound(Material material, Block.SoundType sound) {
            this.material = material;
            this.sound = sound;
        }
    }
}

