/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import exnihilo.registries.BarrelRecipeRegistry;
import exnihilo.utils.ItemInfo;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.handler.VanillaPacketHandler;
import net.blay09.mods.excompressum.registry.WoodenCrucibleRegistry;
import net.blay09.mods.excompressum.registry.data.WoodenMeltable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityWoodenCrucible
extends TileEntity
implements IFluidHandler,
ISidedInventory {
    public static final int MAX_FLUID = 1000;
    private static final int UPDATE_INTERVAL = 10;
    private Fluid fluid;
    private int ticksSinceUpdate;
    private boolean isDirty;
    private WoodenMeltable currentMeltable;
    private float solidVolume;
    private float fluidVolume;

    public boolean addItem(ItemStack itemStack) {
        ItemInfo itemInfo;
        if (ExCompressum.woodenCrucibleBarrelRecipes && this.fluidVolume >= 1000.0f && (itemInfo = BarrelRecipeRegistry.getOutput((FluidStack)new FluidStack(this.fluid, (int)this.fluidVolume), (ItemStack)itemStack)) != null) {
            if (!this.field_145850_b.field_72995_K) {
                this.fluidVolume -= 1000.0f;
                EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, itemInfo.getStack());
                entityItem.field_70181_x = 0.2;
                this.field_145850_b.func_72838_d((Entity)entityItem);
                VanillaPacketHandler.sendTileEntityUpdate(this);
            }
            return true;
        }
        WoodenMeltable meltable = WoodenCrucibleRegistry.getMeltable(itemStack);
        float capacityLeft = this.getCapacityLeft();
        if (meltable != null && capacityLeft > (float)meltable.fluidStack.amount && (this.fluid == null || meltable.fluidStack.getFluid() == this.fluid)) {
            this.currentMeltable = meltable;
            this.fluid = meltable.fluidStack.getFluid();
            this.solidVolume += (float)meltable.fluidStack.amount;
            VanillaPacketHandler.sendTileEntityUpdate(this);
            return true;
        }
        return false;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            float rainFall = this.field_145850_b.func_72807_a((int)this.field_145851_c, (int)this.field_145849_e).field_76751_G;
            if ((this.fluidVolume == 0.0f || this.fluid == FluidRegistry.WATER) && this.field_145850_b.func_72896_J() && this.field_145848_d >= this.field_145850_b.func_72825_h(this.field_145851_c, this.field_145849_e) - 1 && rainFall > 0.0f && ExCompressum.woodenCrucibleFillFromRain) {
                this.fluidVolume = Math.min(1000.0f, this.fluidVolume + rainFall);
                this.isDirty = true;
            }
            float speed = ExCompressum.woodenCrucibleSpeed;
            if (this.solidVolume > 0.0f && this.fluidVolume < 1000.0f) {
                this.fluidVolume = Math.min(1000.0f, this.fluidVolume + Math.min(speed, this.solidVolume));
                this.solidVolume = Math.max(0.0f, this.solidVolume - speed);
                this.isDirty = true;
            } else if (this.fluidVolume == 0.0f && this.fluid != null) {
                this.isDirty = true;
            }
            ++this.ticksSinceUpdate;
            if (this.ticksSinceUpdate >= 10) {
                this.ticksSinceUpdate = 0;
                if (this.isDirty) {
                    VanillaPacketHandler.sendTileEntityUpdate(this);
                    this.isDirty = false;
                }
            }
        }
    }

    private float getCapacityLeft() {
        return 1000.0f - this.solidVolume;
    }

    public WoodenMeltable getCurrentMeltable() {
        return this.currentMeltable;
    }

    public boolean hasSolids() {
        return this.solidVolume > 0.0f;
    }

    public float getFluidVolume() {
        return this.fluidVolume;
    }

    public int fill(ForgeDirection from, FluidStack fillStack, boolean doFill) {
        if (fillStack.getFluid().getTemperature() > 500) {
            return 0;
        }
        int capacityLeft = (int)(this.getCapacityLeft() - this.fluidVolume);
        if (!doFill) {
            if (this.fluid == null) {
                return fillStack.amount;
            }
            return this.fluid == fillStack.getFluid() ? Math.min(capacityLeft, fillStack.amount) : 0;
        }
        int addedFluid = Math.min(capacityLeft, fillStack.amount);
        if (this.fluid == null || this.fluid == fillStack.getFluid()) {
            this.fluid = fillStack.getFluid();
            this.fluidVolume += (float)addedFluid;
        } else {
            return 0;
        }
        this.isDirty = true;
        return addedFluid;
    }

    public FluidStack drain(ForgeDirection from, FluidStack drainStack, boolean doDrain) {
        if (this.fluid == null || this.fluid != drainStack.getFluid()) {
            return null;
        }
        FluidStack result = new FluidStack(drainStack, Math.min((int)this.fluidVolume, drainStack.amount));
        if (doDrain) {
            this.fluidVolume -= (float)result.amount;
            this.isDirty = true;
        }
        return result;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.fluid == null) {
            return null;
        }
        FluidStack result = new FluidStack(this.fluid, Math.min((int)this.fluidVolume, maxDrain));
        if (doDrain) {
            this.fluidVolume -= (float)result.amount;
            this.isDirty = true;
        }
        return result;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(new FluidStack(this.fluid != null ? this.fluid : FluidRegistry.WATER, (int)this.fluidVolume), 1000)};
    }

    public int[] func_94128_d(int side) {
        if (side == ForgeDirection.UP.ordinal()) {
            return new int[]{0};
        }
        return new int[0];
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        WoodenMeltable meltable;
        return side == 1 && slot == 1 && (meltable = WoodenCrucibleRegistry.getMeltable(itemStack)) != null && this.getCapacityLeft() >= (float)meltable.fluidStack.amount && (this.fluid == null || meltable.fluidStack.getFluid() == this.fluid);
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.addItem(itemStack);
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return WoodenCrucibleRegistry.isRegistered(itemStack);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.solidVolume = tagCompound.func_74760_g("SolidVolume");
        this.fluid = FluidRegistry.getFluid((String)tagCompound.func_74779_i("FluidName"));
        this.fluidVolume = tagCompound.func_74760_g("FluidVolume");
        if (tagCompound.func_74764_b("Content")) {
            this.currentMeltable = WoodenCrucibleRegistry.getMeltable(ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("Content")));
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (this.currentMeltable != null) {
            tagCompound.func_74782_a("Content", (NBTBase)this.currentMeltable.itemStack.func_77955_b(new NBTTagCompound()));
        }
        tagCompound.func_74776_a("SolidVolume", this.solidVolume);
        if (this.fluid != null) {
            tagCompound.func_74778_a("FluidName", this.fluid.getName());
        }
        tagCompound.func_74776_a("FluidVolume", this.fluidVolume);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public float getSolidVolume() {
        return this.solidVolume;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public boolean hasFluids() {
        return this.fluid != null && this.fluidVolume > 0.0f;
    }
}

