/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collection;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.ModBlocks;
import net.blay09.mods.excompressum.registry.data.ItemAndMetadata;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityBait
extends TileEntity {
    private static final int ENVIRONMENTAL_CHECK_INTERVAL = 200;
    private static final int MAX_BAITS_IN_AREA = 2;
    private static final int MIN_ENV_IN_AREA = 10;
    private static final int MAX_ANIMALS_IN_AREA = 2;
    private static final Multimap<Integer, ItemAndMetadata> envBlockMap = ArrayListMultimap.create();
    private EntityItem renderItemMain;
    private EntityItem renderItemSub;
    private EnvironmentalCondition environmentStatus;
    private int ticksSinceEnvironmentalCheck;

    public void func_145845_h() {
        float range;
        super.func_145845_h();
        ++this.ticksSinceEnvironmentalCheck;
        int metadata = this.func_145832_p();
        if (this.renderItemMain == null) {
            this.renderItemMain = new EntityItem(this.field_145850_b);
            this.renderItemMain.func_92058_a(TileEntityBait.getBaitDisplayItem(metadata, 0));
        }
        if (this.renderItemSub == null) {
            this.renderItemSub = new EntityItem(this.field_145850_b);
            this.renderItemSub.func_92058_a(TileEntityBait.getBaitDisplayItem(metadata, 1));
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextFloat() <= this.getBaitChance(metadata) && this.checkSpawnConditions(true) == EnvironmentalCondition.CanSpawn && this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - (range = 24.0f)), (double)((float)this.field_145848_d - range), (double)((float)this.field_145849_e - range), (double)((float)this.field_145851_c + range), (double)((float)this.field_145848_d + range), (double)((float)this.field_145849_e + range))).isEmpty()) {
            EntityLiving entityLiving = TileEntityBait.getBaitEntityLiving(this.field_145850_b, metadata);
            if (entityLiving != null) {
                if (entityLiving instanceof EntityAgeable && this.field_145850_b.field_73012_v.nextFloat() <= ExCompressum.baitChildChance) {
                    ((EntityAgeable)entityLiving).func_70873_a(-24000);
                }
                entityLiving.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                this.field_145850_b.func_72838_d((Entity)entityLiving);
            }
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private static ItemStack getBaitDisplayItem(int metadata, int i) {
        switch (metadata) {
            case 0: {
                return i == 0 ? new ItemStack(Items.field_151082_bd) : new ItemStack(Items.field_151103_aS);
            }
            case 1: {
                return i == 0 ? new ItemStack(Items.field_151016_H) : new ItemStack(Items.field_151115_aP);
            }
            case 2: {
                return new ItemStack(Items.field_151015_O);
            }
            case 3: {
                return new ItemStack(Items.field_151172_bF);
            }
            case 4: {
                return new ItemStack(Items.field_151014_N);
            }
            case 5: {
                return i == 0 ? GameRegistry.findItemStack((String)"exnihilo", (String)"seed_grass", (int)1) : new ItemStack(Items.field_151015_O);
            }
            case 6: {
                return new ItemStack(Items.field_151115_aP);
            }
        }
        return null;
    }

    private static EntityLiving getBaitEntityLiving(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new EntityWolf(world);
            }
            case 1: {
                return new EntityOcelot(world);
            }
            case 2: {
                return new EntityCow(world);
            }
            case 3: {
                return new EntityPig(world);
            }
            case 4: {
                return new EntityChicken(world);
            }
            case 5: {
                return new EntitySheep(world);
            }
            case 6: {
                return new EntitySquid(world);
            }
        }
        return null;
    }

    private float getBaitChance(int metadata) {
        switch (metadata) {
            case 0: {
                return ExCompressum.baitWolfChance;
            }
            case 1: {
                return ExCompressum.baitOcelotChance;
            }
            case 2: {
                return ExCompressum.baitCowChance;
            }
            case 3: {
                return ExCompressum.baitPigChance;
            }
            case 4: {
                return ExCompressum.baitChickenChance;
            }
            case 5: {
                return ExCompressum.baitSheepChance;
            }
            case 6: {
                return ExCompressum.baitSquidChance;
            }
        }
        return 0.0f;
    }

    public EntityItem getRenderItem(int i) {
        return i == 0 ? this.renderItemMain : this.renderItemSub;
    }

    public EnvironmentalCondition checkSpawnConditions(boolean checkNow) {
        if (checkNow || this.ticksSinceEnvironmentalCheck > 200) {
            int metadata = this.func_145832_p();
            Collection envBlocks = envBlockMap.get((Object)metadata);
            TileEntityBait.populateEnvBlocks();
            int range = 5;
            int rangeVertical = 3;
            int countBait = 0;
            int countEnvBlocks = 0;
            boolean foundWater = false;
            for (int x = this.field_145851_c - 5; x < this.field_145851_c + 5; ++x) {
                for (int y = this.field_145848_d - 3; y < this.field_145848_d + 3; ++y) {
                    for (int z = this.field_145849_e - 5; z < this.field_145849_e + 5; ++z) {
                        Block block = this.field_145850_b.func_147439_a(x, y, z);
                        if (block == ModBlocks.bait) {
                            ++countBait;
                        } else if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                            foundWater = true;
                        }
                        if (envBlocks.contains(new ItemAndMetadata(block, this.field_145850_b.func_72805_g(x, y, z)))) {
                            ++countEnvBlocks;
                            continue;
                        }
                        if (!envBlocks.contains(new ItemAndMetadata(block, Short.MAX_VALUE))) continue;
                        ++countEnvBlocks;
                    }
                }
            }
            this.environmentStatus = !foundWater ? EnvironmentalCondition.NoWater : (countBait > 2 ? EnvironmentalCondition.NearbyBait : (countEnvBlocks < 10 ? EnvironmentalCondition.WrongEnv : (this.field_145850_b.func_72872_a(EntityAnimal.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 10), (double)(this.field_145848_d - 3), (double)(this.field_145849_e - 10), (double)(this.field_145851_c + 10), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 10))).size() > 2 ? EnvironmentalCondition.NearbyAnimal : EnvironmentalCondition.CanSpawn)));
            this.ticksSinceEnvironmentalCheck = 0;
        }
        return this.environmentStatus;
    }

    private static void populateEnvBlocks() {
        if (envBlockMap.size() > 0) {
            return;
        }
        for (int i = 0; i <= 5; ++i) {
            int j;
            if (i == 1) continue;
            envBlockMap.put((Object)i, (Object)new ItemAndMetadata((Block)Blocks.field_150349_c, 0));
            for (j = 0; j <= 2; ++j) {
                envBlockMap.put((Object)i, (Object)new ItemAndMetadata(Blocks.field_150345_g, j));
            }
            for (j = 1; j <= 2; ++j) {
                envBlockMap.put((Object)i, (Object)new ItemAndMetadata((Block)Blocks.field_150329_H, j));
            }
            for (j = 0; j <= 2; ++j) {
                envBlockMap.put((Object)i, (Object)new ItemAndMetadata(Blocks.field_150364_r, j));
            }
            for (j = 0; j <= 1; ++j) {
                envBlockMap.put((Object)i, (Object)new ItemAndMetadata(Blocks.field_150363_s, j));
            }
        }
        envBlockMap.put((Object)1, (Object)new ItemAndMetadata(Blocks.field_150364_r, 3));
        envBlockMap.put((Object)1, (Object)new ItemAndMetadata(Blocks.field_150395_bd, Short.MAX_VALUE));
        envBlockMap.put((Object)1, (Object)new ItemAndMetadata(Blocks.field_150392_bi, 0));
        envBlockMap.put((Object)1, (Object)new ItemAndMetadata(Blocks.field_150345_g, 3));
        envBlockMap.put((Object)6, (Object)new ItemAndMetadata(Blocks.field_150355_j, Short.MAX_VALUE));
        envBlockMap.put((Object)6, (Object)new ItemAndMetadata((Block)Blocks.field_150358_i, Short.MAX_VALUE));
    }

    public boolean isWaterBait() {
        return this.func_145832_p() == 6;
    }

    public static enum EnvironmentalCondition {
        CanSpawn("info.excompressum:baitCanSpawn"),
        NearbyBait("info.excompressum:baitNearbyBait"),
        WrongEnv("info.excompressum:baitWrongEnv"),
        NearbyAnimal("info.excompressum:baitNearbyAnimal"),
        NoWater("info.excompressum:baitNoWater");

        public final String langKey;

        private EnvironmentalCondition(String langKey) {
            this.langKey = langKey;
        }
    }
}

