/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.item;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameRegistry;
import exnihilo.blocks.ores.BlockOre;
import exnihilo.items.hammers.IHammer;
import exnihilo.items.ores.ItemOre;
import java.util.Set;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.ModItems;
import net.blay09.mods.excompressum.registry.CompressedRecipeRegistry;
import net.blay09.mods.excompressum.registry.data.CompressedRecipe;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemOreSmasher
extends ItemTool
implements IHammer {
    private static final String[] ORE_BLOCKS = new String[]{"oreGravel", "oreNetherGravel", "oreSand"};
    private static final String[] ORE_ITEMS = new String[]{"oreBroken", "oreNetherBroken", "oreCrushed"};

    public ItemOreSmasher() {
        super(0.0f, Item.ToolMaterial.EMERALD, (Set)Sets.newHashSet());
        this.func_77655_b("excompressum:ore_smasher");
        this.func_111206_d("excompressum:ore_smasher");
        this.func_77637_a(ExCompressum.creativeTab);
    }

    public boolean canHarvestBlock(Block block, ItemStack itemStack) {
        return this.isOreBlock(new ItemStack(block));
    }

    public float getDigSpeed(ItemStack item, Block block, int meta) {
        if (this.isOreBlock(new ItemStack(block))) {
            return this.field_77864_a;
        }
        return 0.8f;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.func_72855_b(AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1)))) {
            return false;
        }
        for (int i = 0; i < entityPlayer.field_71071_by.field_70462_a.length; ++i) {
            CompressedRecipe recipe;
            ItemStack inventoryStack = entityPlayer.field_71071_by.field_70462_a[i];
            if (inventoryStack == null) continue;
            if (this.isOreItem(inventoryStack) && (recipe = CompressedRecipeRegistry.getRecipe(inventoryStack)) != null && recipe.getResultStack().field_77994_a == 1 && inventoryStack.field_77994_a >= recipe.getSourceStack().field_77994_a) {
                ItemStack resultStack = recipe.getResultStack().func_77946_l();
                resultStack.func_77973_b().func_77648_a(resultStack, entityPlayer, world, x, y, z, side, hitX, hitY, hitZ);
                world.func_147471_g(x, y, z);
                if (resultStack.field_77994_a <= 0) {
                    inventoryStack.field_77994_a -= recipe.getSourceStack().field_77994_a;
                    if (inventoryStack.field_77994_a <= 0) {
                        entityPlayer.field_71071_by.field_70462_a[i] = null;
                    }
                    entityPlayer.func_71038_i();
                    break;
                }
            }
            if (!this.isOreBlock(inventoryStack)) continue;
            inventoryStack.func_77973_b().func_77648_a(inventoryStack, entityPlayer, world, x, y, z, side, hitX, hitY, hitZ);
            world.func_147471_g(x, y, z);
            if (inventoryStack.field_77994_a <= 0) {
                entityPlayer.field_71071_by.field_70462_a[i] = null;
            }
            entityPlayer.func_71038_i();
            break;
        }
        return false;
    }

    private boolean isOreItem(ItemStack itemStack) {
        int[] oreIDs;
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemOre && !item.func_77658_a().endsWith("_powdered")) {
            return true;
        }
        for (int oreID : oreIDs = OreDictionary.getOreIDs((ItemStack)itemStack)) {
            String oreName = OreDictionary.getOreName((int)oreID);
            for (String dictName : ORE_ITEMS) {
                if (!oreName.startsWith(dictName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOreBlock(ItemStack itemStack) {
        int[] oreIDs;
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (block instanceof BlockOre && !((BlockOre)block).getName().endsWith("dust")) {
            return true;
        }
        for (int oreID : oreIDs = OreDictionary.getOreIDs((ItemStack)itemStack)) {
            String oreName = OreDictionary.getOreName((int)oreID);
            for (String dictName : ORE_BLOCKS) {
                if (!oreName.startsWith(dictName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHammer(ItemStack itemStack) {
        return true;
    }

    public static void registerRecipes(Configuration config) {
        if (config.getBoolean("Ore Smasher", "items", true, "If set to false, the recipe for the ore smasher will be disabled.")) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)ModItems.oreSmasher), new Object[]{" CD", " SC", "S  ", Character.valueOf('C'), Blocks.field_150462_ai, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('S'), "stickWood"}));
        }
    }
}

