/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import exnihilo.registries.HammerRegistry;
import exnihilo.registries.helpers.Smashable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.registry.ChickenStickRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class ItemChickenStick
extends ItemTool {
    public static final Set<Block> blocksEffectiveAgainst = Sets.newHashSet();

    public ItemChickenStick() {
        super(0.0f, Item.ToolMaterial.EMERALD, blocksEffectiveAgainst);
        this.func_77655_b("excompressum:chicken_stick");
        this.func_111206_d("excompressum:chicken_stick");
        this.func_77637_a(ExCompressum.creativeTab);
        this.func_77656_e(0);
    }

    public String func_77653_i(ItemStack itemStack) {
        return ChickenStickRegistry.getChickenStickName() != null ? ChickenStickRegistry.getChickenStickName() : super.func_77653_i(itemStack);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean flag) {
        if (ChickenStickRegistry.getChickenStickName() != null) {
            list.add(EnumChatFormatting.GRAY + "(Chicken Stick)");
        }
    }

    public boolean func_77644_a(ItemStack itemStack, EntityLivingBase attacker, EntityLivingBase target) {
        this.playChickenSound(attacker.field_70170_p, (int)attacker.field_70165_t, (int)attacker.field_70163_u, (int)attacker.field_70161_v);
        return super.func_77644_a(itemStack, attacker, target);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        this.playChickenSound(world, (int)entityPlayer.field_70165_t, (int)entityPlayer.field_70163_u, (int)entityPlayer.field_70161_v);
        entityPlayer.func_71038_i();
        return super.func_77659_a(itemStack, world, entityPlayer);
    }

    public boolean onBlockStartBreak(ItemStack itemStack, int x, int y, int z, EntityPlayer entityPlayer) {
        int metadata;
        World world = entityPlayer.field_70170_p;
        if (world.field_72995_K || entityPlayer instanceof FakePlayer) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (!ChickenStickRegistry.isValidBlock(block, metadata = world.func_72805_g(x, y, z))) {
            return false;
        }
        ArrayList rewards = HammerRegistry.getRewards((Block)block, (int)metadata);
        if (rewards == null || rewards.isEmpty()) {
            return false;
        }
        for (Smashable reward : rewards) {
            if (!(world.field_73012_v.nextFloat() <= reward.chance)) continue;
            EntityItem entityItem = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(reward.item, 1, reward.meta));
            double motion = 0.05;
            entityItem.field_70159_w = world.field_73012_v.nextGaussian() * motion;
            entityItem.field_70181_x = 0.2;
            entityItem.field_70179_y = world.field_73012_v.nextGaussian() * motion;
            world.func_72838_d((Entity)entityItem);
        }
        world.func_147468_f(x, y, z);
        this.playChickenSound(world, x, y, z);
        if (!world.field_72995_K && world.field_73012_v.nextFloat() <= ChickenStickRegistry.chickenStickSpawnChance) {
            EntityChicken entityChicken = new EntityChicken(world);
            entityChicken.func_70107_b((double)x, (double)y, (double)z);
            world.func_72838_d((Entity)entityChicken);
        }
        return true;
    }

    public boolean canHarvestBlock(Block block, ItemStack itemStack) {
        return ChickenStickRegistry.isValidBlock(block, 0);
    }

    public float getDigSpeed(ItemStack item, Block block, int meta) {
        if (ChickenStickRegistry.isValidBlock(block, meta) && block.getHarvestLevel(meta) <= this.field_77862_b.func_77996_d()) {
            return this.field_77864_a * 0.75f;
        }
        return 0.8f;
    }

    public int func_77619_b() {
        return 0;
    }

    public Multimap func_111205_h() {
        return HashMultimap.create();
    }

    private void playChickenSound(World world, int x, int y, int z) {
        if (world.field_73012_v.nextFloat() <= ChickenStickRegistry.chickenStickSoundChance) {
            String soundName = null;
            if (ChickenStickRegistry.chickenStickSounds.length > 0) {
                soundName = ChickenStickRegistry.chickenStickSounds[world.field_73012_v.nextInt(ChickenStickRegistry.chickenStickSounds.length)];
            }
            if (soundName != null) {
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, soundName, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }
}

