/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.collect.Lists;
import exnihilo.registries.CompostRegistry;
import exnihilo.registries.helpers.Compostable;
import exnihilo.utils.ItemInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class RecipeHandlerComposting
extends TemplateRecipeHandler {
    private static final int SLOTS_PER_PAGE = 45;

    public void drawBackground(int recipeIndex) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)166, (int)130);
        Point highlightPoint = ((CachedCompostRecipe)((Object)this.arecipes.get(recipeIndex))).highlightPoint;
        if (highlightPoint != null) {
            GuiDraw.drawTexturedModalRect((int)highlightPoint.x, (int)highlightPoint.y, (int)166, (int)0, (int)18, (int)18);
        }
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack itemStack, List<String> list, int recipeIdx) {
        Compostable compostable;
        CachedCompostRecipe recipe = (CachedCompostRecipe)((Object)this.arecipes.get(recipeIdx));
        ItemStack sourceStack = ((PositionedStack)((CachedCompostRecipe)recipe).input.get((int)0)).item;
        if (itemStack != null && itemStack != sourceStack && (compostable = CompostRegistry.getItem((Item)itemStack.func_77973_b(), (int)itemStack.func_77960_j())) != null) {
            list.add("Amount: " + compostable.value);
        }
        return list;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(75, 22, 15, 13), "excompressum.composting", new Object[0]));
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getGuiTexture() {
        return "excompressum:textures/gui/neiComposting.png";
    }

    public String getRecipeName() {
        return "Composting (Barrel)";
    }

    public void loadCraftingRecipes(String outputID, Object ... wat) {
        if (!outputID.equals("excompressum.neiComposting")) {
            super.loadCraftingRecipes(outputID, wat);
            return;
        }
        ArrayList resultStacks = Lists.newArrayList();
        for (Map.Entry entry : CompostRegistry.entries.entrySet()) {
            ItemStack itemStack = ((ItemInfo)entry.getKey()).getStack();
            itemStack.field_77994_a = (int)Math.ceil(1.0f / ((Compostable)entry.getValue()).value);
            resultStacks.add(itemStack);
        }
        this.addCached(resultStacks, new ItemStack(Blocks.field_150346_d), null);
    }

    public void loadCraftingRecipes(ItemStack itemStack) {
        if (itemStack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150346_d)) {
            return;
        }
        ArrayList resultStacks = Lists.newArrayList();
        for (Map.Entry entry : CompostRegistry.entries.entrySet()) {
            ItemStack compostStack = ((ItemInfo)entry.getKey()).getStack();
            compostStack.field_77994_a = (int)Math.ceil(1.0f / ((Compostable)entry.getValue()).value);
            resultStacks.add(compostStack);
        }
        this.addCached(resultStacks, itemStack, null);
    }

    public void loadUsageRecipes(ItemStack itemStack) {
        if (!CompostRegistry.containsItem((Item)itemStack.func_77973_b(), (int)itemStack.func_77960_j())) {
            return;
        }
        ArrayList resultStacks = Lists.newArrayList();
        for (Map.Entry entry : CompostRegistry.entries.entrySet()) {
            ItemStack compostStack = ((ItemInfo)entry.getKey()).getStack();
            compostStack.field_77994_a = (int)Math.ceil(1.0f / ((Compostable)entry.getValue()).value);
            resultStacks.add(compostStack);
        }
        this.addCached(resultStacks, new ItemStack(Blocks.field_150346_d), itemStack);
    }

    private void addCached(List<ItemStack> resultStacks, ItemStack inputStack, ItemStack highlightStack) {
        int resultCount = resultStacks.size();
        if (resultCount > 45) {
            for (int i = 0; i < resultCount; i += 45) {
                this.arecipes.add(new CachedCompostRecipe(resultStacks.subList(i, Math.min(resultCount, i + 45)), inputStack, highlightStack));
            }
        } else {
            this.arecipes.add(new CachedCompostRecipe(resultStacks, inputStack, highlightStack));
        }
    }

    public class CachedCompostRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> input;
        private final List<PositionedStack> outputs;
        private Point highlightPoint;

        public CachedCompostRecipe(List<ItemStack> resultStacks, ItemStack inputStack, ItemStack highlightStack) {
            super((TemplateRecipeHandler)RecipeHandlerComposting.this);
            this.input = Lists.newArrayList();
            this.outputs = Lists.newArrayList();
            PositionedStack positionedStack = new PositionedStack(inputStack != null ? inputStack : resultStacks, 74, 4);
            positionedStack.setMaxSize(1);
            this.input.add(positionedStack);
            int row = 0;
            int column = 0;
            for (ItemStack resultStack : resultStacks) {
                this.outputs.add(new PositionedStack((Object)resultStack, 3 + 18 * column, 37 + 18 * row));
                if (highlightStack != null && NEIServerUtils.areStacksSameTypeCrafting((ItemStack)highlightStack, (ItemStack)resultStack)) {
                    this.highlightPoint = new Point(2 + 18 * column, 36 + 18 * row);
                }
                if (++column <= 8) continue;
                column = 0;
                ++row;
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(RecipeHandlerComposting.this.cycleticks / 20, this.input);
        }

        public List<PositionedStack> getOtherStacks() {
            return this.outputs;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

